/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.tims.bean.QueryFileBean;
import com.xdja.pams.tims.dao.FileUploadDao;
import com.xdja.pams.tims.entity.FileEntity;
import com.xdja.pams.tims.service.FileUploadService;
import java.io.Serializable;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FileUploadServiceImpl
implements FileUploadService {
    @Autowired
    private FileUploadDao fileUploadDao;
    @Autowired
    protected RepositoryService repositoryService;

    @Override
    public List<FileEntity> queryAll() {
        return this.fileUploadDao.queryAll();
    }

    @Override
    public List<QueryFileBean> query(QueryFileBean queryBean, Page page) {
        return this.fileUploadDao.query(queryBean, page);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public FileEntity save(FileEntity file) {
        return this.fileUploadDao.saveFileInfo(file);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(FileEntity file) {
        FileEntity file_old = this.getFileEntity((Serializable)((Object)file.getId()));
        file_old.setWjmc(file.getWjmc());
        file_old.setWjms(file.getWjms());
        this.fileUploadDao.updateFileInfo(file_old);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Serializable id) {
        FileEntity file = this.fileUploadDao.getFileEntity(id);
        this.fileUploadDao.delete(file);
    }

    @Override
    public FileEntity getFileEntity(Serializable id) {
        return this.fileUploadDao.getFileEntity(id);
    }

    @Override
    public boolean checkSuffix(String fileSuffix) {
        return false;
    }
}

