/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.service.impl;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.upms.service.ControlAreaService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ControlAreaServiceImpl
implements ControlAreaService {
    @Autowired
    private PersonDao personDao;
    @Autowired
    private DepartmentDao depDao;

    @Override
    public List<Person> queryPersonList(QueryPersonBean queryBean, String controlDepIds, Page page) {
        StringBuilder selectHql = new StringBuilder("from Person as person where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) from Person as person where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCode())) {
            selectHql.append("and person.code like ? ");
            countHql.append("and person.code like ? ");
            paramList.add("%" + queryBean.getCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and person.name like ? ");
            countHql.append("and person.name like ? ");
            paramList.add("%" + queryBean.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getMobile())) {
            selectHql.append("and person.mobile like ? ");
            countHql.append("and person.mobile like ? ");
            paramList.add("%" + queryBean.getMobile() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getIdentifier())) {
            selectHql.append("and person.identifier like ? ");
            countHql.append("and person.identifier like ? ");
            paramList.add("%" + queryBean.getIdentifier() + "%");
        }
        return this.personDao.queryPersonListByHql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    public void updatePersonControlPoliced(String person_id, String[] police_id) {
        Person p = this.personDao.queryPersonById(person_id);
        p.setControlPolicedList(null);
        this.personDao.updatePerson(p);
        ArrayList<CommonCode> policeList = new ArrayList<CommonCode>();
        for (int i = 0; i < police_id.length; ++i) {
            CommonCode police = new CommonCode();
            police.setId(police_id[i]);
            policeList.add(police);
        }
        p.setControlPolicedList(policeList);
        this.personDao.updatePerson(p);
    }

    @Override
    public void updatePersonControlDep(String person_id, String[] dep_id) {
        Person p = this.personDao.queryPersonById(person_id);
        p.setControlDepdList(null);
        this.personDao.updatePerson(p);
        ArrayList<Department> deptList = new ArrayList<Department>();
        for (int i = 0; i < dep_id.length; ++i) {
            Department dept = new Department();
            dept.setId(dep_id[i]);
            deptList.add(dept);
        }
        p.setControlDepdList(deptList);
        this.personDao.updatePerson(p);
    }

    @Override
    public List<CommonCode> queryPersonControlPolicedList(String person_id) {
        Person p = this.personDao.queryPersonById(person_id);
        return p.getControlPolicedList();
    }

    @Override
    public List<Department> queryPersonControlDepList(String person_id) {
        Person p = this.personDao.queryPersonById(person_id);
        return p.getControlDepdList();
    }

    @Override
    public Person queryPerson(String person_id) {
        return this.personDao.queryPersonById(person_id);
    }
}

