/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.service.impl;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.dao.BimsGroupDao;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.upms.dao.SysPowerDao;
import com.xdja.pams.upms.dao.SysRoleDao;
import com.xdja.pams.upms.dao.TerminalPowerDao;
import com.xdja.pams.upms.dao.TerminalRoleDao;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.UserPowerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserPowerServiceImpl
implements UserPowerService {
    @Autowired
    private BimsGroupDao bimsGroupDao;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private TerminalRoleDao terminalRoleDao;
    @Autowired
    private SysPowerDao sysPowerDao;
    @Autowired
    private TerminalPowerDao terminalPowerDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    private static Logger log = Logger.getLogger(UserPowerServiceImpl.class);

    @Override
    public List<Person> queryPersonList(QueryPersonBean queryBean, String controlDepIds, Page page) {
        StringBuilder selectHql = new StringBuilder("from Person as person where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) from Person as person where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCode())) {
            selectHql.append("and person.code like ? ");
            countHql.append("and person.code like ? ");
            paramList.add("%" + queryBean.getCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and person.name like ? ");
            countHql.append("and person.name like ? ");
            paramList.add("%" + queryBean.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getMobile())) {
            selectHql.append("and person.mobile like ? ");
            countHql.append("and person.mobile like ? ");
            paramList.add("%" + queryBean.getMobile() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getIdentifier())) {
            selectHql.append("and person.identifier like ? ");
            countHql.append("and person.identifier like ? ");
            paramList.add("%" + queryBean.getIdentifier() + "%");
        }
        return this.personDao.queryPersonListByHql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    public List<Role> queryRoleListByPerson(Person person, String type) {
        if (person != null) {
            Person p = this.personDao.queryPersonById(person.getId());
            List<Role> rlist = p.getRoleList();
            ArrayList<Role> roleList = null;
            if (StringUtils.isNotBlank((CharSequence)type) && type.equals("1")) {
                for (int i = 0; i < rlist.size(); ++i) {
                    roleList = new ArrayList<Role>();
                    Role role = this.sysRoleDao.queryRoleById(rlist.get(i).getId());
                    roleList.add(role);
                }
                return roleList;
            }
            if (StringUtils.isNotBlank((CharSequence)type) && type.equals("2")) {
                for (int i = 0; i < rlist.size(); ++i) {
                    roleList = new ArrayList();
                    Role role = this.terminalRoleDao.queryRoleById(rlist.get(i).getId());
                    roleList.add(role);
                }
                return roleList;
            }
        }
        return null;
    }

    @Override
    public List<SysPower> querySysRolePower(Role role) {
        Role p = this.sysRoleDao.queryRoleById(role.getId());
        return p.getSysPowerSet();
    }

    @Override
    public List<GprsMenu> queryTerminalRolePower(Role role) {
        Role p = this.terminalRoleDao.queryRoleById(role.getId());
        return p.getGprsMenuSet();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updatePersonRoleByPersonid(String person_id, String roleIds, String type) {
        Person person = this.personDao.queryPersonById(person_id);
        String sysRoleIds = "";
        String terminalRoleIds = "";
        for (Role role : person.getRoleList()) {
            if ("2".equals(role.getType())) {
                terminalRoleIds = terminalRoleIds + role.getId() + ",";
                continue;
            }
            sysRoleIds = sysRoleIds + role.getId() + ",";
        }
        if (!"".equals(sysRoleIds)) {
            sysRoleIds = sysRoleIds.substring(0, sysRoleIds.length() - 1);
        }
        if (!"".equals(terminalRoleIds)) {
            terminalRoleIds = terminalRoleIds.substring(0, terminalRoleIds.length() - 1);
        }
        roleIds = "sysRole".equals(type) ? roleIds + "," + terminalRoleIds : roleIds + "," + sysRoleIds;
        String[] roleArray = roleIds.split(",");
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (int i = 0; i < roleArray.length; ++i) {
            Role r = this.sysRoleDao.queryRoleById(roleArray[i]);
            roleList.add(r);
        }
        person.setRoleList(roleList);
    }

    @Override
    public Map<String, SysPower> queryPersonRoleList(String person_id) {
        Person person = this.userManageService.queryPersonById(person_id);
        HashMap<String, SysPower> map = new HashMap<String, SysPower>();
        if (person != null) {
            HashSet<Role> rolSet = new HashSet<Role>();
            List<Role> roleList = person.getRoleList();
            rolSet.addAll(roleList);
            List<BimsGroup> groupList = person.getGroupList();
            for (BimsGroup group : groupList) {
                rolSet.addAll(group.getRoleList());
            }
            List<Department> depList = this.depManageService.getHLDep(person.getDepartment().getId());
            for (Department dep : depList) {
                rolSet.addAll(dep.getRoleList());
            }
            for (Role role : rolSet) {
                for (SysPower sysPower : role.getSysPowerSet()) {
                    if (map.containsKey(sysPower.getId()) || !sysPower.getStatus().equals("1")) continue;
                    map.put(sysPower.getId(), sysPower);
                }
            }
        }
        return map;
    }

    @Override
    public Map<String, GprsMenu> queryPersonTerminalPowerList(String person_id) {
        Person person = this.userManageService.queryPersonById(person_id);
        HashMap<String, GprsMenu> map = new HashMap<String, GprsMenu>();
        if (person != null) {
            HashSet<Role> rolSet = new HashSet<Role>();
            List<Role> roleList = person.getRoleList();
            rolSet.addAll(roleList);
            List<BimsGroup> groupList = person.getGroupList();
            for (BimsGroup group : groupList) {
                rolSet.addAll(group.getRoleList());
            }
            List<Department> depList = this.depManageService.getHLDep(person.getDepartment().getId());
            for (Department dep : depList) {
                rolSet.addAll(dep.getRoleList());
            }
            for (Role role : rolSet) {
                for (GprsMenu gprsPower : role.getGprsMenuSet()) {
                    if (map.containsKey(gprsPower.getN_id()) || !gprsPower.getC_zt().equals("1") || !this.checkParentEnableGprsMenu(gprsPower.getC_fjcd())) continue;
                    map.put(gprsPower.getN_id(), gprsPower);
                }
            }
        }
        return map;
    }

    private boolean checkParentEnableGprsMenu(String parentId) {
        if (parentId == null) {
            return true;
        }
        GprsMenu gm = this.terminalPowerDao.queryById(parentId);
        if (gm == null) {
            return true;
        }
        if ("1".equals(gm.getC_zt())) {
            return this.checkParentEnableGprsMenu(gm.getC_fjcd());
        }
        return false;
    }

    @Override
    public String getPersonSysRoles(String personId) {
        Person p = this.userManageService.queryPersonById(personId);
        List<Role> rolelist = p.getRoleList();
        String roleId = "";
        for (Role role : rolelist) {
            if (role.getType().equals("2")) continue;
            roleId = roleId + role.getId() + ",";
        }
        return roleId;
    }

    @Override
    public String getPersonTerminalRoles(String personId) {
        Person p = this.userManageService.queryPersonById(personId);
        List<Role> rolelist = p.getRoleList();
        String roleId = "";
        for (Role role : rolelist) {
            if (!role.getType().equals("2")) continue;
            roleId = roleId + role.getId() + ",";
        }
        return roleId;
    }

    @Override
    public boolean judgeIsSuperAdmin(Person person) {
        for (Role role : person.getRoleList()) {
            if (!"40288cef41a15e770141a15e870f0002".equals(role.getId())) continue;
            return true;
        }
        return false;
    }
}

