/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.userbusiness.controller;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.TaskListBean;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.DeviceWorkflowService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.wfms.bean.WorkflowFlowBean;
import com.xdja.pams.wfms.service.WorkflowUtilService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Scope(value="session")
@Controller
public class UserBusinessController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(UserBusinessController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private CommonCodePbService commonCodeService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceWorkflowService deviceWorkflowService;
    @Autowired
    private WorkflowUtilService wus;
    @Autowired
    private TaskService taskService;

    @RequestMapping(value={"/userbusiness/UserBusinessController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            Operator operator = this.getOperator(request);
            Person person = operator.getPerson();
            map.put((Object)"commType", (Object)this.commonCodeService.getCodeNameByCode(person.getCommType(), "2015"));
            List<Device> deviceList = this.deviceService.getAllByPersonId(person.getId());
            String TFStatus = "\u672a\u7533\u8bf7";
            String USBKEYStatus = "\u672a\u7533\u8bf7";
            WorkflowFlowBean TFWFB = null;
            WorkflowFlowBean USBKEYWFB = null;
            String isRSubmitTF = null;
            String isRSubmitUSBKEY = null;
            if (deviceList != null && !deviceList.isEmpty()) {
                for (Device device : deviceList) {
                    if ("11".equals(device.getState())) continue;
                    if ("0".equals(device.getState())) {
                        List<TaskListBean> tasks = this.deviceWorkflowService.findTodoTasksByDeviceId(device.getId());
                        if (tasks == null || tasks.isEmpty()) continue;
                        TaskListBean tb = tasks.get(0);
                        List taskList = this.taskService.createTaskQuery().processInstanceId(tb.getProcessInstanceId()).list();
                        if (taskList == null || taskList.isEmpty()) continue;
                        Task task = (Task)taskList.get(0);
                        String isRSubmilt = null;
                        if (StringUtils.isNotBlank((CharSequence)task.getAssignee())) {
                            isRSubmilt = task.getAssignee();
                        }
                        List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnList(tb.getProcessInstanceId());
                        if ("3".equals(device.getType())) {
                            TFStatus = task.getName();
                            TFWFB = wfbList.get(0);
                            isRSubmitTF = isRSubmilt;
                            map.put((Object)"TFTASKID", (Object)task.getId());
                            map.put((Object)"TFDWID", (Object)tb.getId());
                            map.put((Object)"TFDEVICEID", (Object)device.getId());
                        }
                        if (!"2".equals(device.getType())) continue;
                        USBKEYStatus = task.getName();
                        USBKEYWFB = wfbList.get(0);
                        isRSubmitUSBKEY = isRSubmilt;
                        map.put((Object)"USBKEYTASKID", (Object)task.getId());
                        map.put((Object)"USBKEYDWID", (Object)tb.getId());
                        map.put((Object)"USBKEYDEVICEID", (Object)device.getId());
                        continue;
                    }
                    if ("3".equals(device.getType())) {
                        TFStatus = this.commonCodeService.getCodeNameByCode(device.getState(), "2001");
                    }
                    if (!"2".equals(device.getType())) continue;
                    USBKEYStatus = this.commonCodeService.getCodeNameByCode(device.getState(), "2001");
                }
            }
            map.put((Object)"mobileList", (Object)Util.toJsonStr(person.getMobiledList()));
            map.put((Object)"TFStatus", (Object)TFStatus);
            map.put((Object)"USBKEYStatus", (Object)USBKEYStatus);
            map.put((Object)"USBKEYWFB", (Object)Util.toJsonStr(USBKEYWFB));
            map.put((Object)"TFWFB", (Object)Util.toJsonStr(TFWFB));
            map.put((Object)"isRSubmitUSBKEY", isRSubmitUSBKEY);
            map.put((Object)"isRSubmitTF", isRSubmitTF);
            map.put((Object)"person", (Object)person);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    private String getCardStatus(String id) {
        List<TaskListBean> tasks = this.deviceWorkflowService.findTodoTasksByDeviceId(id);
        if (tasks == null || tasks.isEmpty()) {
            return null;
        }
        TaskListBean tb = tasks.get(0);
        List taskList = this.taskService.createTaskQuery().processInstanceId(tb.getProcessInstanceId()).list();
        if (taskList == null || taskList.isEmpty()) {
            return null;
        }
        Task task = (Task)taskList.get(0);
        return task.getName();
    }

    @RequestMapping(value={"/userbusiness/UserBusinessController/toApply.do"})
    public String toApply(ModelMap map, String cardType) {
        map.put((Object)"cardType", (Object)cardType);
        return "userbusiness/default/apply";
    }

    @RequestMapping(value={"/userbusiness/UserBusinessController/toInfo.do"})
    public String toInfo(ModelMap map, String id) {
        Device device = this.deviceService.get((Serializable)((Object)id));
        map.put((Object)"device", (Object)device);
        return "userbusiness/default/info";
    }

    @RequestMapping(value={"/userbusiness/UserBusinessController/saveApply.do"})
    public void saveApply(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, Device device) {
        Operator operator = this.getOperator(request);
        Person person = operator.getPerson();
        HashMap<String, String> rtn = new HashMap<String, String>();
        try {
            if ("2".equals(device.getType())) {
                device.setUseType("1");
            } else {
                device.setUseType("0");
            }
            device.setPersonId(person.getId());
            device.setState("0");
            device.setBindingDate(new Date());
            device.setBindingState(this.userManageService.getBingDingState(device.getType()));
            device.setLockState("0");
            device.setFlag("1");
            this.deviceService.save(device, person);
            rtn.put("rtnCode", "0");
        }
        catch (Exception e) {
            log.error("\u5b89\u5168\u5361\u7533\u8bf7\u5931\u8d25\uff01", (Throwable)e);
            rtn.put("rtnCode", "1");
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtn));
    }
}

