/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.control;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.app.bean.AppStatisticsQueryBean;
import pams.function.mdp.app.service.AppStatisticsService;

@Controller
@Scope(value="session")
public class AppStatisticsController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(AppStatisticsController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private AppStatisticsService appStatisticsService;

    @RequestMapping(value={"/app/AppStatisticsController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/app/AppStatisticsController/getList.do"})
    public void getStatisticsList(HttpServletResponse response, AppStatisticsQueryBean queryBean) {
        try {
            String ret = this.appStatisticsService.getStatisticsList(queryBean);
            Util.writeUtf8Text((HttpServletResponse)response, (String)ret);
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
        }
    }

    @RequestMapping(value={"/app/AppStatisticsController/getAppListDropDown.do"})
    public void getAppList(HttpServletResponse response) {
        try {
            String ret = this.appStatisticsService.getAllAppList();
            JSONObject retJson = JSONObject.parseObject((String)ret);
            String appList = retJson.getJSONArray("data").toJSONString();
            Util.writeUtf8JSON((HttpServletResponse)response, (String)appList);
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
        }
    }

    @RequestMapping(value={"/app/AppStatisticsController/getAppType.do"})
    public void getAppType(HttpServletResponse response) {
        try {
            String appTypeList = this.appStatisticsService.getAppTypeList();
            Util.writeUtf8JSON((HttpServletResponse)response, (String)appTypeList);
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
        }
    }
}

