/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.app.bean.AppCommentQueryBean;
import pams.function.mdp.app.bean.AppCommentReplyBean;
import pams.function.mdp.app.bean.AppCommentReplyQueryBean;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.app.service.CommentManagerService;

@Service
public class CommentManagerServiceImpl
implements CommentManagerService {
    private static Logger logger = LoggerFactory.getLogger(CommentManagerServiceImpl.class);
    private SystemConfigService systemConfigService;
    private String MDP_URL;
    private HttpRequestUtil httpRequest = new HttpRequestUtil();

    @Override
    public JSONObject getCommentDetail(String arId) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/appReviewDetail.do", "{\"arId\":\"" + arId + "\"}");
        JSONObject originJsonObject = JSONObject.parseObject((String)ret);
        return originJsonObject.getJSONObject("data");
    }

    @Override
    public String getCommentList(AppCommentQueryBean queryBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/appReviewList.do", JSON.toJSONString((Object)((Object)queryBean)));
        JSONObject retJsonObject = JSONObject.parseObject((String)ret);
        JSONArray rows = retJsonObject.getJSONObject("data").getJSONArray("arList");
        rows = rows == null ? new JSONArray() : rows;
        retJsonObject.remove((Object)"data");
        retJsonObject.put("rows", (Object)rows);
        return retJsonObject.toJSONString();
    }

    @Override
    public String getCommentReplyList(AppCommentReplyQueryBean queryBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/appReviewReplyList.do", JSON.toJSONString((Object)((Object)queryBean)));
        JSONObject originJsonObject = JSONObject.parseObject((String)ret);
        JSONObject dataArea = originJsonObject.getJSONObject("data");
        originJsonObject.remove((Object)"data");
        if (null != dataArea) {
            JSONArray rows = dataArea.getJSONArray("arList");
            if (null == rows) {
                rows = new JSONArray();
            }
            originJsonObject.put("rows", (Object)rows);
            ret = originJsonObject.toJSONString();
        }
        return ret;
    }

    @Override
    public PageBean addReply(AppCommentReplyBean replyBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String result = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/appReviewer.do", JSON.toJSONString((Object)replyBean));
        return (PageBean)JSON.parseObject((String)result, PageBean.class);
    }

    @Override
    public PageBean deleteReplyById(String replyId, String delPersonId) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        JSONObject param = new JSONObject();
        param.put("arrId", (Object)replyId);
        param.put("delPersonId", (Object)delPersonId);
        String result = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/appReviewReplyDel.do", JSON.toJSONString((Object)param));
        return (PageBean)JSON.parseObject((String)result, PageBean.class);
    }

    @Override
    public PageBean deleteCommentById(String ArId, String delPersonId) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        JSONObject param = new JSONObject();
        param.put("arId", (Object)ArId);
        param.put("delPersonId", (Object)delPersonId);
        param.put("userFlag", (Object)"4");
        String result = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/appReviewDel.do", JSON.toJSONString((Object)param));
        return (PageBean)JSON.parseObject((String)result, PageBean.class);
    }

    public String postJson(String url, String jsonParam) {
        try {
            String ret = this.httpRequest.postJson(url, jsonParam);
            logger.info(ret);
            return ret;
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
            return "";
        }
    }

    public String postJson(String url) {
        return this.postJson(url, "{}");
    }

    @Autowired
    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
}

