/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.mdpcard.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.mdpcard.bean.Rt;
import pams.function.mdp.mdpcard.entity.ThirdKey;
import pams.function.mdp.mdpcard.service.MdpCardService;

@Controller
@Scope(value="session")
public class MdpCardControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(MdpCardControl.class);
    @Autowired
    private MdpCardService mdpCardService;

    @RequestMapping(value={"sso/mdpusermanagercontroller/listkey.do"})
    public void listKeys(String personId, HttpServletResponse response) {
        try {
            log.info("\u5f00\u59cb\u83b7\u53d6key\u5217\u8868, personId: {}", (Object)personId);
            List<ThirdKey> list = this.mdpCardService.listKey(personId);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(list));
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6key\u5f02\u5e38", (Throwable)e2);
        }
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/checkcard.do"})
    public void checkCard(String personId, String cardId, String keyId, HttpServletResponse response) {
        Rt rt;
        try {
            log.info("\u5f00\u59cb\u6821\u9a8ckey, personId : " + personId + ", cardId: " + cardId + ", keyId:" + keyId);
            rt = Strings.isEmpty((String)personId) || Strings.isEmpty((String)cardId) ? Rt.fail("\u53c2\u6570\u5f02\u5e38") : this.mdpCardService.checkKey(personId, cardId, keyId);
        }
        catch (Exception e2) {
            rt = Rt.fail("\u7cfb\u7edf\u5f02\u5e38");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)rt));
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/downloadcert.do"})
    public void downloadCert(String personId, String cardId, String keyId, String pubKey, HttpServletResponse response) {
        Rt rt;
        try {
            log.info("\u5f00\u59cb\u4e0b\u8f7d\u8bc1\u4e66, personId : " + personId + ", cardId: " + cardId + ", keyId:" + keyId + ", pubKey: " + pubKey);
            rt = Strings.isEmpty((String)personId) || Strings.isEmpty((String)cardId) || Strings.isEmpty((String)pubKey) ? Rt.fail("\u53c2\u6570\u5f02\u5e38") : this.mdpCardService.downloadCert(personId, cardId, pubKey, keyId, this.operator.getPerson().getId());
        }
        catch (Exception e2) {
            rt = Rt.fail("\u7cfb\u7edf\u5f02\u5e38");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)rt));
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/revoke.do"})
    public void revokeCert(String personId, String keyId, HttpServletResponse response) {
        Rt rt;
        try {
            rt = Strings.isEmpty((String)personId) || Strings.isEmpty((String)keyId) ? Rt.fail("\u53c2\u6570\u5f02\u5e38") : this.mdpCardService.revokeCert(personId, keyId, this.operator.getPerson().getId());
        }
        catch (Exception e2) {
            rt = Rt.fail("\u7cfb\u7edf\u5f02\u5e38");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)rt));
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/deleteKey.do"})
    public void deleteKey(String keyId, HttpServletResponse response) {
        Rt rt;
        try {
            rt = Strings.isEmpty((String)keyId) ? Rt.fail("\u53c2\u6570\u5f02\u5e38") : this.mdpCardService.deleteKey(keyId, this.operator.getPerson().getId());
        }
        catch (Exception e2) {
            rt = Rt.fail("\u7cfb\u7edf\u5f02\u5e38");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)rt));
    }
}

