/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.rsms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syn.bean.QueryParamPoliceAndMDP;
import com.xdja.pams.syn.entity.MDPAndPolice;
import com.xdja.pams.syn.service.PersonMDPService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.rsms.bean.QueryBean;
import pams.function.mdp.rsms.bean.ResApplyBeanList;
import pams.function.mdp.rsms.bean.ResDataSourceTabRst;
import pams.function.mdp.rsms.bean.ResQueryRst;
import pams.function.mdp.rsms.bean.ResSaveRst;
import pams.function.mdp.rsms.bean.ResourceBean;
import pams.function.mdp.rsms.service.ResourceAPIService;

@Controller
@Scope(value="session")
public class ResourceManageController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(ResourceManageController.class);
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private PersonMDPService personMDPService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceAPIService resourceAPIService;

    @RequestMapping(value={"rsms/resourcemanagecontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        int operateResult = 1;
        String sendUrl = "error/error";
        try {
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"person", (Object)this.person);
            map.put((Object)"prsUrl", (Object)prsUrl);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        return sendUrl;
    }

    @RequestMapping(value={"rsms/resourcemanagecontroller/query.do"})
    public void queryResList(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, QueryBean param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ResQueryRst rqr = this.resourceAPIService.queryResList(param, pageParam);
            if (rqr != null) {
                for (ResourceBean resb : rqr.getData()) {
                    String creatorId = resb.getCreator();
                    MDPAndPolice mp = this.personMDPService.getMDPAndPoliceById(creatorId);
                    if (mp == null) continue;
                    resb.setCreator(mp.getName());
                }
            }
            map.put("total", rqr.getTotal());
            map.put("rows", rqr.getData());
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            map.put("total", "0");
            map.put("rows", new ArrayList());
        }
        String json = Util.toJsonStr(map);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"rsms/resourcemanagecontroller/toResInfoPage.do"})
    public String toResourceInfoPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String auditStatus, String op) {
        try {
            ResourceBean resb = this.resourceAPIService.getResById(id, auditStatus);
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            map.put((Object)"resJson", (Object)Util.toJsonStr((Object)resb));
            map.put((Object)"prsUrl", (Object)prsUrl);
            map.put((Object)"resource", (Object)resb);
            map.put((Object)"person", (Object)this.person);
            map.put((Object)"id", (Object)id);
            map.put((Object)"op", (Object)op);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
            return "error/error";
        }
        return "rsms/manage/default/resourceInfo";
    }

    @RequestMapping(value={"rsms/resourcemanagecontroller/toInitiativeEmpowerPage.do"})
    public String toInitiativeEmpowerPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String auditStatus) {
        String sendUrl = "rsms/manage/default/initiativeEmpower";
        try {
            ResourceBean resb = this.resourceAPIService.getResById(id, auditStatus);
            if (resb != null) {
                map.put((Object)"resource", (Object)resb);
                String string = resb.getCreator();
            } else {
                sendUrl = "error/error";
            }
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            map.put((Object)"prsUrl", (Object)prsUrl);
            map.put((Object)"id", (Object)id);
            map.put((Object)"person", (Object)this.person);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u7533\u8bf7\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        return sendUrl;
    }

    @RequestMapping(value={"rsms/resourcemanagecontroller/querymdpuser.do"})
    public void queryMDPUser(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, String q) {
        Page page = new Page();
        page.setRp(10);
        page.setPage(1);
        List list = null;
        try {
            QueryParamPoliceAndMDP param = new QueryParamPoliceAndMDP();
            param.setNameOrCodeOrIdentifier(q);
            param.setIfDelete("0");
            param.setVerifyState("3");
            log.debug("\u67e5\u8be2\u53c2\u6570" + Util.toJsonStr((Object)param));
            list = this.personMDPService.queryMDPAndPolice(param, page);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7528\u6237\u548c\u8b66\u5458\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
        }
        String json = Util.toJsonStr(list);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"rsms/resourcemanagecontroller/queryDataResTab.do"})
    public void queryDataResTab(HttpServletRequest request, HttpServletResponse response, String resId) {
        ResDataSourceTabRst rst = null;
        try {
            rst = this.resourceAPIService.queryDataResTab(resId);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u6570\u636e\u6e90\u8868\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        if (rst != null) {
            String json = Util.toJsonStr(rst.getData());
            log.debug("\u67e5\u8be2\u6210\u529f" + json);
            Util.writeUtf8Text((HttpServletResponse)response, (String)json);
        } else {
            Util.writeUtf8Text((HttpServletResponse)response, (String)"[]");
        }
    }

    @RequestMapping(value={"rsms/resourcemanagecontroller/saveResEmpowerInfo.do"})
    public void saveResEmpowerInfo(HttpServletRequest request, HttpServletResponse response, ResApplyBeanList resApplyBeanList) {
        ResSaveRst rqr = null;
        try {
            rqr = this.resourceAPIService.saveResEmpowerInfo(resApplyBeanList);
        }
        catch (Exception e2) {
            log.error("\u4e3b\u52a8\u6388\u6743\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            rqr = new ResSaveRst();
            rqr.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
            rqr.setState("0");
        }
        String json = Util.toJsonStr((Object)rqr);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }
}

