/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.syn.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sso.bean.Result;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syn.bean.QueryParamPoliceAndMDP;
import com.xdja.pams.syn.entity.MDPPerson;
import com.xdja.pams.syn.service.PersonMDPService;
import com.xdja.pams.upms.entity.Role;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.mdpcard.entity.ThirdKey;
import pams.function.mdp.mdpcard.service.MdpCardService;

@Controller
@Scope(value="session")
public class MdpUserManagerController
extends BaseControler {
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private PersonMDPService personMDPService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private MdpCardService mdpCardService;
    private static final Logger log = LoggerFactory.getLogger(MdpUserManagerController.class);

    @RequestMapping(value={"sso/mdpusermanagercontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        int operateResult = 1;
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        return sendUrl;
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/query.do"})
    public void query(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, QueryParamPoliceAndMDP param) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        List list = null;
        try {
            param.setIfDelete("0");
            param.setControlDep(this.getControlDeps(request));
            log.info("\u67e5\u8be2\u53c2\u6570" + Util.toJsonStr((Object)param));
            list = this.personMDPService.queryMDP(param, page);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u5e73\u53f0\u7528\u6237\u548c\u8b66\u5458\u4fe1\u606f\u5931\u8d25", (Throwable)e2);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        map.put("rows", list);
        String json = Util.toJsonStr(map);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/toMDPUserInfoPage.do"})
    public String toMDPUserInfoPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String isWriteCard, String keyId) {
        try {
            ThirdKey thirdKey;
            String mdpServerUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            MDPPerson mdpperson = this.personMDPService.getMDPPersonById(id);
            map.put((Object)"mdpperson", (Object)mdpperson);
            map.put((Object)"person", (Object)this.person);
            map.put((Object)"mdpServerUrl", (Object)mdpServerUrl);
            map.put((Object)"isWriteCard", (Object)isWriteCard);
            if (keyId != null && !"".equals(keyId) && (thirdKey = this.mdpCardService.keyDetail(keyId)) != null) {
                map.put((Object)"cardId", (Object)thirdKey.getCardId());
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        return "mdp/userManager/default/userInfo";
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/toCardList.do"})
    public String toCardListInfoPage(ModelMap map, String personId) {
        map.addAttribute("personId", (Object)personId);
        return "mdp/userManager/default/cardListInfo";
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/verifyUser.do"})
    public void verifyUser(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, String id, String verifyState) {
        Result result = new Result();
        try {
            this.personMDPService.updateMDPPersonVerifyState(id, verifyState);
            result.setFlag("0");
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u5ba1\u6279\u72b6\u6001\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr((Object)result);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/refusePerson.do"})
    public void refusePerson(HttpServletRequest request, HttpServletResponse response, String id, String verifyState, String refuseReason, String verifyType, String ifDepManager, String name) {
        HashMap<String, String> rstMap = null;
        String rst = null;
        try {
            String path = request.getRealPath("/");
            String reqParam = "type=json&id=" + id + "&verifyState=" + verifyState + "&verifyType=" + verifyType + "&verifyPersonId=" + this.person.getId() + "&ifDepManager=" + ifDepManager + "&refuseReason=" + refuseReason + "&name=" + name;
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String urlStr = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            urlStr = urlStr + "/service/pmag/verify/refusePerson.do";
            rst = httpclient.post(urlStr, reqParam);
        }
        catch (Exception e2) {
            log.error("\u8c03\u7528\u5ba1\u6279\u62d2\u7edd\u63a5\u53e3\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
            rstMap = new HashMap<String, String>();
            rstMap.put("state", "0");
            rstMap.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        if (rstMap != null) {
            rst = Util.toJsonStr(rstMap);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)rst);
    }

    public void deleteMDPPerson(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, QueryParamPoliceAndMDP queryParam) {
        HashMap<String, String> rstMap = null;
        String rst = null;
        try {
            String reqParam = "type=json&id=" + queryParam.getId() + "&deleteReason=" + queryParam.getDeleteReason();
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String urlStr = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            urlStr = urlStr + "/service/pmag/manage/delPerson.do";
            rst = httpclient.post(urlStr, reqParam);
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            rstMap = new HashMap<String, String>();
            rstMap.put("state", "0");
            rstMap.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        if (rstMap != null) {
            rst = Util.toJsonStr(rstMap);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)rst);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/deleteUser.do"})
    public void cancelMDPPerson(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, QueryParamPoliceAndMDP queryParam) {
        HashMap<String, String> rstMap = null;
        String rst = null;
        try {
            this.setOperator(request);
            String reqParam = "type=json&id=" + queryParam.getId() + "&operator=" + this.person.getId();
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String urlStr = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            urlStr = urlStr + "/appManagerControl/delPerson.do";
            rst = httpclient.post(urlStr, reqParam);
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            rstMap = new HashMap<String, String>();
            rstMap.put("state", "0");
            rstMap.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        if (rstMap != null) {
            rst = Util.toJsonStr(rstMap);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)rst);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/toRoleMgPage.do"})
    public String toRoleMgPage(ModelMap map, String personId) {
        map.addAttribute("personId", (Object)personId);
        return "mdp/userManager/default/userSysRolePowerList";
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/getRoleTree.do"})
    public void getRoleTree(HttpServletRequest request, HttpServletResponse response, String personId) {
        ArrayList list = new ArrayList();
        try {
            MDPPerson person = this.personMDPService.getMDPPersonById(personId);
            String psersonRoleIds = "";
            if (person.getPersonRoles() != null) {
                for (Role role : person.getPersonRoles()) {
                    psersonRoleIds = psersonRoleIds + "," + role.getId();
                }
                List codes = this.commonCodeService.queryByType("MDP_PTJS");
                for (CommonCode code : codes) {
                    if ("0".equals(code.getCode()) || "3".equals(code.getCode()) && !"1".equals(person.getPersonType())) continue;
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    node.put("id", code.getCode());
                    node.put("text", code.getName());
                    node.put("state", "close");
                    node.put("checked", psersonRoleIds.indexOf(code.getCode()) >= 0);
                    list.add(node);
                }
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2MDP\u6743\u9650\u6811\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
        }
        String treeJson = Util.toJsonStr(list);
        Util.writeUtf8Text((HttpServletResponse)response, (String)treeJson);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/savePersonRole.do"})
    public void savePersonRole(HttpServletRequest request, HttpServletResponse response, String personId, String roleIds) {
        Result result = new Result();
        try {
            String[] roleArr = roleIds.split(",");
            MDPPerson person = this.personMDPService.getMDPPersonById(personId);
            ArrayList<Role> roles = new ArrayList<Role>();
            for (String roleId : roleArr) {
                if (StringUtils.isBlank((CharSequence)roleId)) continue;
                Role role = new Role();
                role.setId(roleId);
                roles.add(role);
            }
            person.setPersonRoles(roles);
            this.personMDPService.updateMDPPerson(person);
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            result.setFlag("0");
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58MDP\u7528\u6237\u6743\u9650\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr((Object)result);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/resetPassword.do"})
    public void resetPassword(HttpServletRequest request, HttpServletResponse response, String personId) {
        Result result = new Result();
        try {
            String password = this.systemConfigPbService.getValueByCode("defaultPass");
            this.personMDPService.updateMDPPassword(password, personId);
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            result.setFlag("0");
        }
        catch (Exception e2) {
            log.error("\u4fdd\u5b58MDP\u7528\u6237\u6743\u9650\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr((Object)result);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"sso/mdpusermanagercontroller/setEnabled.do"})
    public void setEnabled(HttpServletRequest request, HttpServletResponse response, String personId, String enabled) {
        Result result = new Result();
        try {
            this.personMDPService.setEnabled(personId, enabled);
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            result.setFlag("0");
        }
        catch (Exception e2) {
            log.error("\u542f\u7528\u6216\u7981\u7528\u5f00\u53d1\u8005\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            result.setFlag("1");
            result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e2.getMessage());
        }
        String resultJson = Util.toJsonStr((Object)result);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }
}

