/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.controller;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.service.LoginService;
import com.xdja.pams.scms.util.Strings;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.oauth.bean.OAuthBean;
import pams.function.oauth.bean.OAuthException;
import pams.function.oauth.bean.PersonInfoBean;
import pams.function.oauth.bean.Result;
import pams.function.oauth.bean.ThirdClientBean;
import pams.function.oauth.bean.TokenBean;
import pams.function.oauth.entity.OAuthCode;
import pams.function.oauth.entity.RefreshToken;
import pams.function.oauth.entity.UserToken;
import pams.function.oauth.service.OAuthCodeService;
import pams.function.oauth.service.OAuthService;
import pams.function.oauth.service.OAuthTokenService;
import pams.function.oauth.service.ThirdClientService;
import pams.function.oauth.utils.OAssert;

@Controller
@RequestMapping(value={"/oauth2"})
public class OAuthController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthController.class);
    @Autowired
    private OAuthService oAuthService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private ThirdClientService thirdClientService;
    @Autowired
    private OAuthCodeService oAuthCodeService;
    @Autowired
    private OAuthTokenService oAuthTokenService;
    private static Map<String, String> loginErr = new HashMap<String, String>();
    private static final String SYS_ERR = "0";
    private static final String ACCOUNT_NULL = "1";
    private static final String PASSWORD_NULL = "2";
    private static final String SCOPES_NULL = "3";
    private static final String ACCOUNT_UNEXISTS = "4";
    private static final String PASSWORD_WRONG = "5";
    private static final String ACCOUNT_LOCKED = "6";
    private static final String CLIENT_SCOPE_UNVALID = "7";
    private static final String CODE_CREATE_ERR = "8";

    @RequestMapping(value={"/authorize.do"})
    public String toAuthorizationPage(OAuthBean oAuthBean, HttpServletRequest request, ModelMap modelMap) {
        try {
            Map<String, Object> result = this.oAuthService.toAuthorizePage(oAuthBean);
            modelMap.addAttribute("data", result);
            String msg = oAuthBean.getMsg();
            if (Strings.isNotEmpty((String)msg)) {
                modelMap.addAttribute("msg", (Object)loginErr.get(msg));
            }
            modelMap.addAttribute("flag", (Object)true);
        }
        catch (Exception e) {
            modelMap.addAttribute("flag", (Object)false);
            if (e instanceof OAuthException) {
                modelMap.addAttribute("msg", (Object)e.getMessage());
            }
            modelMap.addAttribute("msg", (Object)"\u7cfb\u7edf\u5f02\u5e38");
        }
        return "oauth/authorize/index";
    }

    @RequestMapping(value={"/login.do"})
    public void doAuthorize(OAuthBean oAuthBean, HttpServletRequest request, HttpServletResponse response) {
        String errorCode = null;
        try {
            this.oAuthService.toAuthorizePage(oAuthBean);
        }
        catch (Exception e) {
            errorCode = e instanceof OAuthException ? CLIENT_SCOPE_UNVALID : SYS_ERR;
        }
        if (Strings.isEmpty((String)errorCode)) {
            LOGGER.info("\u5f00\u59cb\u767b\u5f55\u53c2\u6570", (Object)oAuthBean);
            try {
                String userName = oAuthBean.getUsername();
                String password = oAuthBean.getPassword();
                String scopes = oAuthBean.getScopes();
                OAssert.state(Strings.isNotEmpty((String)userName), ACCOUNT_NULL);
                OAssert.state(Strings.isNotEmpty((String)password), PASSWORD_NULL);
                OAssert.state(Strings.isNotEmpty((String)scopes), SCOPES_NULL);
                Person person = this.userManageService.getUserByCode(userName);
                if (person == null) {
                    person = this.userManageService.getUserByIdentifer(userName);
                }
                if (person == null) {
                    person = this.userManageService.getUserByMobile(userName);
                }
                OAssert.state(person != null, ACCOUNT_UNEXISTS);
                OAssert.state(!this.loginService.judgeIslock(person), ACCOUNT_LOCKED);
                OAssert.state(!this.loginService.judgeIslock2(person), ACCOUNT_LOCKED);
                OAssert.state(Md5PwdEncoder.getInstance().encodePassword(oAuthBean.getPassword()).equals(person.getPassword()), PASSWORD_WRONG);
                String code = this.oAuthService.createCode(oAuthBean.getClient_id(), person.getId(), oAuthBean.getScopes());
                OAssert.state(Strings.isNotEmpty((String)code), CODE_CREATE_ERR);
                StringBuilder redirectPath = new StringBuilder(oAuthBean.getRedirect_uri());
                redirectPath.append("?code=").append(code);
                if (Strings.isNotEmpty((String)oAuthBean.getState())) {
                    redirectPath.append("&state=").append(oAuthBean.getState());
                }
                response.sendRedirect(redirectPath.toString());
                return;
            }
            catch (Exception e) {
                LOGGER.error("\u8ba4\u8bc1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                errorCode = e instanceof OAuthException ? e.getMessage() : SYS_ERR;
            }
        }
        if (Strings.isNotEmpty((String)errorCode)) {
            StringBuilder redirectPath = new StringBuilder(request.getContextPath());
            redirectPath.append("/oauth2/authorize.do?").append(oAuthBean.spellQueryParam());
            redirectPath.append("&msg=").append(errorCode);
            try {
                response.sendRedirect(redirectPath.toString());
            }
            catch (Exception e) {
                LOGGER.error("\u8df3\u8f6c\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @RequestMapping(value={"/access_token.do"})
    public void getToken(OAuthBean oAuthBean, HttpServletResponse response) {
        String result = "";
        try {
            if (StringUtils.isBlank((CharSequence)oAuthBean.getClient_id()) || StringUtils.isBlank((CharSequence)oAuthBean.getClient_secret()) || StringUtils.isBlank((CharSequence)oAuthBean.getCode()) || StringUtils.isBlank((CharSequence)oAuthBean.getGrant_type()) || !"authorization_code".equals(oAuthBean.getGrant_type())) {
                result = Result.fail(PASSWORD_WRONG, "\u53c2\u6570\u65e0\u6548");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            ThirdClientBean thirdClientBean = this.thirdClientService.queryByIdAndSecret(oAuthBean.getClient_id(), oAuthBean.getClient_secret());
            if (thirdClientBean == null) {
                result = Result.fail(PASSWORD_NULL, "\u672a\u8ba4\u8bc1\u901a\u8fc7\uff0c\u60a8\u7684\u5ba2\u6237\u7aefID\u548c\u79d8\u94a5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u7981\u7528");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            OAuthCode oAuthCode = this.oAuthCodeService.queryByCodeAndClientId(oAuthBean.getCode(), oAuthBean.getClient_id());
            long now = System.currentTimeMillis();
            if (oAuthCode == null || oAuthCode.getExpire() < now) {
                result = Result.fail(SCOPES_NULL, "\u65e0\u6548\u7684code");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            if (ACCOUNT_NULL.equals(oAuthCode.getIsUsed())) {
                result = Result.fail(ACCOUNT_LOCKED, "code\u5df2\u88ab\u4f7f\u7528");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            TokenBean tokenBean = this.oAuthTokenService.createToken(oAuthCode);
            this.oAuthCodeService.revokeCode(oAuthCode);
            result = Result.success(tokenBean);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result = Result.fail("\u670d\u52a1\u5668\u7e41\u5fd9");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/get_user_info.do"})
    public void getUserInfo(String token, HttpServletResponse response) {
        String result = "";
        try {
            if (StringUtils.isBlank((CharSequence)token)) {
                result = Result.fail(PASSWORD_WRONG, "\u53c2\u6570\u65e0\u6548");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            UserToken userToken = this.oAuthTokenService.queryByToken(token);
            if (userToken == null) {
                result = Result.fail(ACCOUNT_UNEXISTS, "\u65e0\u6548\u7684\u7968\u636e");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            if (userToken.getExpire() < System.currentTimeMillis()) {
                result = Result.fail(CLIENT_SCOPE_UNVALID, "\u7968\u636e\u5df2\u8fc7\u671f");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            if (StringUtils.isBlank((CharSequence)userToken.getScopeId())) {
                result = Result.success(new PersonInfoBean());
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            ThirdClientBean thirdClientBean = this.thirdClientService.getById(userToken.getClientId());
            if (thirdClientBean == null || !ACCOUNT_NULL.equals(thirdClientBean.getState())) {
                result = Result.fail(PASSWORD_NULL, "\u672a\u8ba4\u8bc1\u901a\u8fc7\uff0c\u7b2c\u4e09\u65b9\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u505c\u7528");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            Person person = this.userManageService.queryPersonById(userToken.getPersonId());
            if (person == null) {
                result = Result.fail(CODE_CREATE_ERR, "\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            PersonInfoBean personInfoBean = this.oAuthTokenService.queryUserInfo(userToken.getScopeId(), person);
            result = Result.success(personInfoBean);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result = Result.fail("\u670d\u52a1\u5668\u7e41\u5fd9");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/refresh_token.do"})
    public void refreshToken(OAuthBean oAuthBean, HttpServletResponse response) {
        String result = "";
        try {
            if (StringUtils.isBlank((CharSequence)oAuthBean.getClient_id()) || StringUtils.isBlank((CharSequence)oAuthBean.getClient_secret()) || StringUtils.isBlank((CharSequence)oAuthBean.getRefresh_token())) {
                result = Result.fail(PASSWORD_WRONG, "\u53c2\u6570\u65e0\u6548");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            ThirdClientBean thirdClientBean = this.thirdClientService.queryByIdAndSecret(oAuthBean.getClient_id(), oAuthBean.getClient_secret());
            if (thirdClientBean == null) {
                result = Result.fail(PASSWORD_NULL, "\u672a\u8ba4\u8bc1\u901a\u8fc7\uff0c\u60a8\u7684\u5ba2\u6237\u7aefID\u548c\u79d8\u94a5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u7981\u7528");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            RefreshToken refreshToken = this.oAuthTokenService.queryRefreshToken(oAuthBean.getRefresh_token());
            if (refreshToken == null) {
                result = Result.fail("9", "\u65e0\u6548\u7684refreshToken");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            if (refreshToken.getExpire() < System.currentTimeMillis()) {
                result = Result.fail("10", "refreshToken\u5df2\u8fc7\u671f");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            TokenBean tokenBean = this.oAuthTokenService.delayToken(refreshToken);
            result = Result.success(tokenBean);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result = Result.fail("\u670d\u52a1\u5668\u7e41\u5fd9");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/get_token_info.do"})
    public void queryTokenInfo(String token, HttpServletResponse response) {
        String result = "";
        try {
            if (StringUtils.isBlank((CharSequence)token)) {
                result = Result.fail(PASSWORD_WRONG, "\u53c2\u6570\u65e0\u6548");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            UserToken userToken = this.oAuthTokenService.queryByToken(token);
            if (userToken == null) {
                result = Result.fail(ACCOUNT_UNEXISTS, "\u65e0\u6548\u7684\u7968\u636e");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
                return;
            }
            result = Result.success(userToken);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result = Result.fail("\u670d\u52a1\u5668\u7e41\u5fd9");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/api_doc.do"})
    public String toApiDoc() {
        return "oauth/authorize/pams-oauth-api-doc";
    }

    static {
        loginErr.put(SYS_ERR, "\u7cfb\u7edf\u5f02\u5e38");
        loginErr.put(ACCOUNT_NULL, "\u8d26\u53f7\u53c2\u6570\u4e3a\u7a7a");
        loginErr.put(PASSWORD_NULL, "\u5bc6\u7801\u53c2\u6570\u4e3a\u7a7a");
        loginErr.put(SCOPES_NULL, "\u7528\u6237\u672a\u6388\u6743");
        loginErr.put(ACCOUNT_UNEXISTS, "\u8d26\u6237\u4e0d\u5b58\u5728");
        loginErr.put(PASSWORD_WRONG, "\u5bc6\u7801\u9519\u8bef");
        loginErr.put(ACCOUNT_LOCKED, "\u8d26\u6237\u88ab\u9501\u5b9a");
        loginErr.put(CLIENT_SCOPE_UNVALID, "\u7b2c\u4e09\u65b9\u548c\u6743\u9650\u6821\u9a8c\u5931\u8d25");
        loginErr.put(CODE_CREATE_ERR, "\u521b\u5efacode\u5931\u8d25");
    }
}

