/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.control.ResourceController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.oauth.bean.PersonInfoTypeEnum;
import pams.function.oauth.entity.InterfaceResource;
import pams.function.oauth.entity.PersonInfoResource;
import pams.function.oauth.service.ResourcesService;

@Controller
@Scope(value="session")
@RequestMapping(value={"/oauth/resourcePowerController"})
public class ResourcePowerController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private ResourcesService resourcesService;
    private static final Logger logger = LoggerFactory.getLogger(ResourceController.class);

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.addAttribute("types", PersonInfoTypeEnum.list());
        }
        catch (Exception e) {
            logger.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/interface/list.do"})
    public void getInterfaceList(String interfaceName, Integer page, Integer rows, HttpServletResponse response) {
        try {
            if (page == null) {
                page = 1;
            }
            if (rows == null) {
                rows = 10;
            }
            Map<String, Object> result = this.resourcesService.pageInterfaceSource(interfaceName, page, rows);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/personInfo/list.do"})
    public void getPersonInfoList(String personInfoName, String type, Integer page, Integer rows, HttpServletResponse response) {
        try {
            if (page == null) {
                page = 1;
            }
            if (rows == null) {
                rows = 10;
            }
            Map<String, Object> result = this.resourcesService.pagePersonInfoSource(personInfoName, type, page, rows);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/toOpt.do"})
    public String toOptPage(String id, String type, ModelMap modelMap) {
        String viewPath;
        if ("interface".equals(type)) {
            viewPath = "oauth/resourcePower/default/interface_opt";
            if (Strings.isNotEmpty((String)id)) {
                modelMap.addAttribute("interface", (Object)this.resourcesService.getInterFaceById(id));
            } else {
                modelMap.addAttribute("interface", (Object)new InterfaceResource());
            }
        } else {
            viewPath = "oauth/resourcePower/default/personInfo_opt";
            if (Strings.isNotEmpty((String)id)) {
                modelMap.addAttribute("personInfo", (Object)this.resourcesService.getPersonInfoById(id));
            } else {
                modelMap.addAttribute("personInfo", (Object)new PersonInfoResource());
            }
            modelMap.addAttribute("types", PersonInfoTypeEnum.list());
        }
        return viewPath;
    }

    @RequestMapping(value={"/interface/addOrEdit.do"})
    public void addInterface(InterfaceResource resource, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        try {
            String cxt = request.getContextPath();
            this.resourcesService.addOrEditInterface(resource, cxt);
        }
        catch (Exception e) {
            result.put("flag", "0");
            result.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/personInfo/addOrEdit.do"})
    public void addPersonInfo(PersonInfoResource resource, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        try {
            this.resourcesService.addOrEditPersonInfo(resource);
        }
        catch (Exception e) {
            result.put("flag", "0");
            result.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/personInfo/cols.do"})
    public String getColumnsInfoByType(String type, String oldcol, ModelMap map) {
        try {
            List<Map<String, String>> list = this.resourcesService.getColumnInfo(type);
            map.addAttribute("list", list);
            map.addAttribute("oldcol", (Object)oldcol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "oauth/resourcePower/default/columnSelector";
    }

    @RequestMapping(value={"/interface/changeState.do"})
    public void changeInterfaceState(String id, String state, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        try {
            if (Strings.isEmpty((String)id) || Strings.isEmpty((String)state)) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            this.resourcesService.changeInterfaceState(id, state);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            result.put("flag", "0");
            result.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/personInfo/delete.do"})
    public void deletePersonInfo(String id, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        try {
            if (Strings.isEmpty((String)id)) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            this.resourcesService.deletePersonInfo(id);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            result.put("flag", "0");
            result.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }
}

