/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.oauth.bean.GrantTypeEnum;
import pams.function.oauth.bean.PersonInfoTypeEnum;
import pams.function.oauth.bean.Result;
import pams.function.oauth.bean.ScopeBean;
import pams.function.oauth.entity.InterfaceResource;
import pams.function.oauth.entity.PersonInfoResource;
import pams.function.oauth.service.ResourcesService;
import pams.function.oauth.service.ScopeService;

@Controller
@Scope(value="session")
@RequestMapping(value={"/oauth/scopeController"})
public class ScopeController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private ScopeService scopeService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourcesService resourcesService;
    private static final Logger logger = LoggerFactory.getLogger(ScopeController.class);

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/list.do"})
    public void list(ScopeBean scopeBean, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int operateResult = 0;
        try {
            Page page = new Page();
            if (scopeBean.getRows() == null) {
                page.setRp(10);
            } else {
                page.setRp(scopeBean.getRows().intValue());
            }
            if (scopeBean.getPage() == null) {
                page.setPage(1);
            } else {
                page.setPage(scopeBean.getPage().intValue());
            }
            List<ScopeBean> scopeBeanList = this.scopeService.list(scopeBean, page);
            result.put("rows", scopeBeanList);
            result.put("total", page.getTotal());
            result.put("code", "0");
            result.put("pageNo", page.getPage());
            operateResult = 1;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("code", "1");
            result.put("msg", e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/toAdd.do"})
    public String toAdd() {
        return "oauth/scope/default/add";
    }

    @RequestMapping(value={"/add.do"})
    public void add(ScopeBean scopeBean, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)scopeBean.getCode()) || StringUtils.isBlank((CharSequence)scopeBean.getName()) || StringUtils.isBlank((CharSequence)scopeBean.getScopeType()) || StringUtils.isBlank((CharSequence)scopeBean.getDetail())) {
                result = Result.fail("\u53c2\u6570\u9519\u8bef");
            } else {
                scopeBean.setCreateBy(this.person.getId());
                this.scopeService.add(scopeBean);
                operateResult = 1;
                result = Result.success("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/toEdit.do"})
    public String toEdit(String id, ModelMap map) {
        try {
            ScopeBean scopeBean = this.scopeService.queryById(id);
            map.put((Object)"scopeBean", (Object)scopeBean);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "error/error";
        }
        return "oauth/scope/default/edit";
    }

    @RequestMapping(value={"/edit.do"})
    public void edit(ScopeBean scopeBean, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)scopeBean.getName()) || StringUtils.isBlank((CharSequence)scopeBean.getDetail()) || StringUtils.isBlank((CharSequence)scopeBean.getId())) {
                result = Result.fail("\u53c2\u6570\u9519\u8bef");
            } else {
                scopeBean.setUpdateBy(this.person.getId());
                this.scopeService.update(scopeBean);
                operateResult = 1;
                result = Result.success("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/updateState.do"})
    public void updateState(ScopeBean scopeBean, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            scopeBean.setUpdateBy(this.person.getId());
            this.scopeService.updateState(scopeBean);
            operateResult = 1;
            result = Result.success("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/del.do"})
    public void del(String id, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            this.scopeService.delete(id, this.person.getId());
            operateResult = 1;
            result = Result.success("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"toEmpower.do"})
    public String toEmpower(String id, ModelMap map) {
        map.put((Object)"scopeId", (Object)id);
        return "oauth/scope/default/empower";
    }

    @RequestMapping(value={"/getScopeResource.do"})
    public void getScopeResource(String id, HttpServletResponse response) {
        String result = "";
        try {
            ScopeBean scopeBean = this.scopeService.queryById(id);
            ArrayList rootTree = new ArrayList();
            if (scopeBean != null) {
                List<String> resourceIds = this.scopeService.getScopeResourceIdsByType(id, scopeBean.getScopeType());
                if (GrantTypeEnum.PERSON.getCode().equals(scopeBean.getScopeType())) {
                    HashMap<String, Object> userMap = new HashMap<String, Object>();
                    userMap.put("id", "userRoot");
                    userMap.put("text", "\u7528\u6237\u8d44\u6e90\u6743\u9650");
                    ArrayList typeList = new ArrayList();
                    for (PersonInfoTypeEnum type : PersonInfoTypeEnum.values()) {
                        HashMap<String, Object> mapType = new HashMap<String, Object>();
                        mapType.put("id", type.getCode());
                        mapType.put("text", type.getMsg());
                        List<PersonInfoResource> personInfoResources = this.resourcesService.queryPersonResByType(type.getCode());
                        ArrayList childList = new ArrayList();
                        if (CollectionUtils.isEmpty(personInfoResources)) continue;
                        for (PersonInfoResource resource : personInfoResources) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("id", resource.getId());
                            map.put("text", resource.getName() + "---" + resource.getColumnName());
                            if (resourceIds.contains(resource.getId())) {
                                map.put("checked", true);
                            }
                            childList.add(map);
                        }
                        mapType.put("children", childList);
                        typeList.add(mapType);
                    }
                    userMap.put("children", typeList);
                    rootTree.add(userMap);
                } else {
                    HashMap<String, Object> userMap = new HashMap<String, Object>();
                    userMap.put("id", "interfaceRoot");
                    userMap.put("text", "\u63a5\u53e3\u8d44\u6e90\u6743\u9650");
                    List<InterfaceResource> interfaceResources = this.resourcesService.queryAllInterfaceRes();
                    ArrayList childList = new ArrayList();
                    for (InterfaceResource resource : interfaceResources) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", resource.getId());
                        if ("1".equals(resource.getState())) {
                            map.put("text", resource.getName());
                        } else {
                            map.put("text", resource.getName() + "\uff08\u5df2\u7981\u7528\uff09");
                        }
                        if (resourceIds.contains(resource.getId())) {
                            map.put("checked", true);
                        }
                        childList.add(map);
                    }
                    userMap.put("children", childList);
                    rootTree.add(userMap);
                }
            }
            result = Util.toJsonStr(rootTree);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/empower.do"})
    public void empower(String scopeId, String resourceIds, String type, HttpServletResponse response) {
        String result;
        try {
            this.scopeService.empower(scopeId, resourceIds, type);
            result = Result.success("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }
}

