/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.CommonCodeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.oauth.bean.GrantTypeEnum;
import pams.function.oauth.bean.Result;
import pams.function.oauth.bean.ScopeBean;
import pams.function.oauth.bean.ThirdClientBean;
import pams.function.oauth.service.ScopeService;
import pams.function.oauth.service.ThirdClientService;

@Controller
@Scope(value="session")
@RequestMapping(value={"/oauth/thirdClientController"})
public class ThirdClientController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private ThirdClientService thirdClientService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ScopeService scopeService;
    @Autowired
    private CommonCodeService commonCodeService;
    private static final Logger logger = LoggerFactory.getLogger(ThirdClientController.class);

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/getGrantType.do"})
    public void getGrantType(HttpServletResponse response) {
        List<Object> result = new ArrayList();
        try {
            result = GrantTypeEnum.list();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/list.do"})
    public void list(ThirdClientBean thirdClientBean, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int operateResult = 0;
        try {
            Page page = new Page();
            if (thirdClientBean.getPage() == null) {
                page.setPage(1);
            } else {
                page.setPage(thirdClientBean.getPage().intValue());
            }
            if (thirdClientBean.getRows() == null) {
                page.setRp(10);
            } else {
                page.setRp(thirdClientBean.getRows().intValue());
            }
            List<ThirdClientBean> list = this.thirdClientService.list(thirdClientBean, page);
            result.put("rows", list);
            result.put("total", page.getTotal());
            result.put("pageNo", page.getPage());
            result.put("code", "0");
            operateResult = 1;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("code", "1");
            result.put("msg", e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/toRegister.do"})
    public String toRegister() {
        return "oauth/thirdClient/default/add";
    }

    @RequestMapping(value={"/save.do"})
    public void save(ThirdClientBean thirdClientBean, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)thirdClientBean.getClientName()) || StringUtils.isBlank((CharSequence)thirdClientBean.getGrantType()) || StringUtils.isBlank((CharSequence)thirdClientBean.getClientUrl())) {
                result = Result.fail("\u53c2\u6570\u9519\u8bef");
            } else {
                thirdClientBean.setCreateBy(this.person.getId());
                this.thirdClientService.add(thirdClientBean);
                result = Result.success("");
                operateResult = 1;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/updateState.do"})
    public void updateState(String clientId, String state, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            this.thirdClientService.updateState(clientId, state, this.person.getId());
            result = Result.success("");
            operateResult = 1;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/del.do"})
    public void del(String clientId, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            this.thirdClientService.delete(clientId, this.person.getId());
            result = Result.success("");
            operateResult = 1;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/toEdit.do"})
    public String toEdit(String clientId, ModelMap map) {
        try {
            ThirdClientBean thirdClientBean = this.thirdClientService.getById(clientId);
            map.put((Object)"thirdClientBean", (Object)thirdClientBean);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "error/error";
        }
        return "oauth/thirdClient/default/edit";
    }

    @RequestMapping(value={"/update.do"})
    public void update(ThirdClientBean thirdClientBean, HttpServletResponse response) {
        String result;
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)thirdClientBean.getClientName()) || StringUtils.isBlank((CharSequence)thirdClientBean.getGrantType()) || StringUtils.isBlank((CharSequence)thirdClientBean.getClientUrl()) || StringUtils.isBlank((CharSequence)thirdClientBean.getClientId())) {
                result = Result.fail("\u53c2\u6570\u9519\u8bef");
            } else {
                thirdClientBean.setUpdateBy(this.person.getId());
                this.thirdClientService.update(thirdClientBean);
                result = Result.success("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"toEmpower.do"})
    public String toEmpower(String clientId, ModelMap map) {
        map.put((Object)"clientId", (Object)clientId);
        return "oauth/thirdClient/default/empower";
    }

    @RequestMapping(value={"/getClientScope.do"})
    public void getClientScope(String clientId, HttpServletResponse response) {
        String result = "";
        try {
            ThirdClientBean clientBean = this.thirdClientService.getById(clientId);
            ArrayList rootTree = new ArrayList();
            if (clientBean != null) {
                String[] grantTypes;
                for (String grantType : grantTypes = clientBean.getGrantType().split(",")) {
                    String codeName = GrantTypeEnum.getNameByCode(grantType);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", "root");
                    map.put("text", codeName);
                    List<ScopeBean> scopeBeanList = this.scopeService.queryScopeByType(grantType);
                    List<String> clientScopeIds = this.scopeService.getClientScopeId(clientId);
                    ArrayList childList = new ArrayList();
                    for (ScopeBean scopeBean : scopeBeanList) {
                        HashMap<String, Object> childMap = new HashMap<String, Object>();
                        childMap.put("id", scopeBean.getId());
                        if ("2".equals(scopeBean.getState())) {
                            childMap.put("text", scopeBean.getCode() + "---" + scopeBean.getName() + "\uff08\u5df2\u7981\u7528\uff09");
                        } else {
                            childMap.put("text", scopeBean.getCode() + "---" + scopeBean.getName());
                        }
                        if (clientScopeIds.contains(scopeBean.getId())) {
                            childMap.put("checked", true);
                        }
                        childList.add(childMap);
                    }
                    map.put("children", childList);
                    rootTree.add(map);
                }
            }
            result = Util.toJsonStr(rootTree);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/empower.do"})
    public void empower(String clientId, String scopeIds, HttpServletResponse response) {
        String result;
        try {
            this.thirdClientService.empower(clientId, scopeIds);
            result = Result.success("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = Result.fail(e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }
}

