/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.dao.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.util.Strings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.oauth.dao.ResourcesDao;
import pams.function.oauth.entity.InterfaceResource;
import pams.function.oauth.entity.PersonInfoResource;

@Repository
public class ResourcesDaoImpl
implements ResourcesDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<InterfaceResource> pageInterfaces(String key, Page page) {
        String sql = "select *  ";
        String countSql = "select count(1) ";
        StringBuilder sb = new StringBuilder(" from T_OAUTH_INTERFACE_RES where state <> '3' ");
        ArrayList<String> param = new ArrayList<String>();
        if (Strings.isNotEmpty((String)key)) {
            sb.append(" and NAME like ? ");
            param.add("%" + key + "%");
        }
        return this.baseDao.getListBySQL(countSql + sb.toString(), sql + sb.toString(), param.toArray(), page, InterfaceResource.class);
    }

    @Override
    public List<PersonInfoResource> pagePersonInfo(String name, String type, Page page) {
        String sql = "select * ";
        String countSql = "select count(1) ";
        StringBuilder sb1 = new StringBuilder(" from T_OAUTH_PERSON_INFO_RES where 1=1  ");
        ArrayList<String> param = new ArrayList<String>();
        if (Strings.isNotEmpty((String)name)) {
            sb1.append(" and name like ? ");
            param.add("%" + name + "%");
        }
        if (Strings.isNotEmpty((String)type)) {
            sb1.append(" and type = ? ");
            param.add(type);
        }
        return this.baseDao.getListBySQL(countSql + sb1.toString(), sql + sb1.toString(), param.toArray(), page, PersonInfoResource.class);
    }

    @Override
    public InterfaceResource getInterfaceById(String id) {
        return (InterfaceResource)this.baseDao.getObjectById(InterfaceResource.class, (Serializable)((Object)id));
    }

    @Override
    public PersonInfoResource getPersonInfoById(String id) {
        return (PersonInfoResource)this.baseDao.getObjectById(PersonInfoResource.class, (Serializable)((Object)id));
    }

    @Override
    public void addInterface(InterfaceResource resource) {
        this.baseDao.create((Object)resource);
    }

    @Override
    public void addPersonInfo(PersonInfoResource resource) {
        this.baseDao.create((Object)resource);
    }

    @Override
    public void updateInterface(InterfaceResource resource) {
        this.baseDao.update((Object)resource);
    }

    @Override
    public void updatePersonInfo(PersonInfoResource resource) {
        this.baseDao.update((Object)resource);
    }

    @Override
    public List<Map<String, String>> getColumns(String table) {
        StringBuilder sb = new StringBuilder();
        if ("T_APP".equalsIgnoreCase(table)) {
            return this.getColumnsOfApp(table);
        }
        sb.append("SELECT ").append("    t1.column_name as \"columnName\" , ").append("    t1.data_type as \"dataType\", ").append("    t2.comments as \"comments\" ").append("FROM ").append("    user_tab_cols t1, ").append("    user_col_comments t2 ").append("WHERE ").append("    t1.table_name = t2.table_name ").append("    AND   t1.column_name = t2.column_name ").append("    AND   t1.table_name = upper('").append(table).append("')");
        return this.baseDao.getListBySQL(sb.toString(), null, Map.class);
    }

    private List<Map<String, String>> getColumnsOfApp(String table) {
        return this.baseDao.getColumnInfo(table);
    }

    @Override
    public void deletePersonInfo(String id) {
        PersonInfoResource per = (PersonInfoResource)this.baseDao.getObjectById(PersonInfoResource.class, (Serializable)((Object)id));
        this.baseDao.delete((Object)per);
    }

    @Override
    public int countColumn(String columnName, String type) {
        String sql = "select count(1) from T_OAUTH_PERSON_INFO_RES where COLUMN_NAME=? and type = ?";
        Object[] param = new Object[]{columnName, type};
        BigDecimal bigDecimal = (BigDecimal)this.baseDao.getObjectBySQL(sql, param);
        return bigDecimal.intValue();
    }

    @Override
    public int alignCount(String align) {
        String sql = "select count(1) from T_OAUTH_PERSON_INFO_RES where ALIGN = ?";
        Object[] param = new Object[]{align};
        BigDecimal bigDecimal = (BigDecimal)this.baseDao.getObjectBySQL(sql, param);
        return bigDecimal.intValue();
    }

    @Override
    public List<PersonInfoResource> queryPersonResByType(String type) {
        String sql = "from PersonInfoResource where type = ?";
        return this.baseDao.getListByHQL(sql, (Object[])new String[]{type});
    }

    @Override
    public List<InterfaceResource> queryAllInterfaceRes() {
        String sql = "from InterfaceResource where state <> '3'";
        return this.baseDao.getListByHQL(sql, null);
    }

    @Override
    public List<PersonInfoResource> queryUserResByScopeIds(String scopeIds) {
        List<String> scopeIdList = Arrays.asList(scopeIds.split(","));
        ArrayList<String> nameKeys = new ArrayList<String>();
        nameKeys.add("scopeIds");
        String sql = "select * from T_OAUTH_PERSON_INFO_RES where id in (select rs.res_id from t_oauth_res_scope rs where rs.type = '1' and rs.scope_id in (:scopeIds))";
        return this.baseDao.getListBySQL(sql, new Object[]{scopeIdList}, PersonInfoResource.class, nameKeys);
    }

    @Override
    public List<Map<String, Object>> queryBySql(String sql) {
        return this.baseDao.jdbcTemplateQureyForList(sql);
    }

    @Override
    public List<String> queryAppUserAreaByPersonId(Person person, String[] types) {
        if (person == null) {
            return new ArrayList<String>();
        }
        String depId = person.getDepartment().getId();
        ArrayList<String> values = new ArrayList<String>();
        String sql = " SELECT u.app_id FROM t_app_use_area u, t_app a WHERE a.app_id =u.app_id and a.APP_STATUS= '1' ";
        String sqlCondition = "";
        if (types != null && types.length > 0) {
            for (String type : types) {
                if ("dep".equals(type)) {
                    sqlCondition = sqlCondition + "OR (u.area_id IN (select id from t_department start with id = ? connect by prior parent_id=id AND flag=0 ) AND u.type='dep' AND u.app_id in (SELECT d.app_id FROM (select * from  t_app_use_area  where type = 'dep') d, (select * from  t_app_use_area  where type <> 'dep' and type <>'person') p WHERE d.app_id = p.app_id(+) group by d.app_id having  count(p.type)=0)) ";
                    values.add(depId);
                    continue;
                }
                if ("person".equals(type)) {
                    sqlCondition = sqlCondition + "OR (u.AREA_ID IN (select id  from t_person WHERE FLAG=0  and id=?) AND u.type='person') ";
                    values.add(person.getId());
                    continue;
                }
                sqlCondition = sqlCondition + "OR (u.app_id IN (SELECT a.app_id FROM (SELECT d.app_id, d.area_id as depId,p.area_id as prop,p.type FROM t_app_use_area d, t_app_use_area p WHERE d.app_id=p.app_id and d.type='dep' and p.type='" + type + "' ) a WHERE a.depId IN (select id from t_department start with id in (select dep_id  from t_person where flag=0  and id=? and " + type + " = a.prop) connect by prior parent_id=id)) )";
                values.add(person.getId());
            }
        } else {
            sqlCondition = "    u.AREA_ID = ?";
            values.add(person.getId());
        }
        if (sqlCondition.length() > 2) {
            sqlCondition = sqlCondition.substring(2);
        }
        sql = sql + " and (" + sqlCondition + ")";
        return this.baseDao.getListBySQL(sql, values.toArray(), null);
    }

    @Override
    public List<String> queryAppIdByPackageName(String packageName) {
        String sql = "select app_id from t_app where app_package = ?";
        return this.baseDao.getListBySQL(sql, new Object[]{packageName}, null);
    }
}

