/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.oauth.bean.ScopeBean;
import pams.function.oauth.dao.ScopeDao;
import pams.function.oauth.entity.InterfaceResource;
import pams.function.oauth.entity.PersonInfoResource;
import pams.function.oauth.entity.ResourceScope;
import pams.function.oauth.entity.Scope;

@Repository
public class ScopeDaoImpl
implements ScopeDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<Scope> list(ScopeBean scopeBean, Page page) {
        StringBuilder sql = new StringBuilder();
        sql.append("from Scope where state != '3' ");
        ArrayList<String> param = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)scopeBean.getName())) {
            sql.append(" and name like ?");
            param.add("%" + scopeBean.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)scopeBean.getState())) {
            sql.append(" and state = ? ");
            param.add(scopeBean.getState());
        }
        if (StringUtils.isNotBlank((CharSequence)scopeBean.getCode())) {
            sql.append(" and code like ?");
            param.add("%" + scopeBean.getCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)scopeBean.getScopeType())) {
            sql.append(" and scopeType = ?");
            param.add(scopeBean.getScopeType());
        }
        String selectCount = "select count(*) " + sql;
        sql.append("order by updateTime desc");
        return this.baseDao.getListByHQL(selectCount, sql.toString(), param.toArray(), page);
    }

    @Override
    public void add(Scope scope) {
        this.baseDao.create((Object)scope);
    }

    @Override
    public void update(Scope scope) {
        this.baseDao.update((Object)scope);
    }

    @Override
    public Scope queryById(String id) {
        return (Scope)this.baseDao.getObjectById(Scope.class, (Serializable)((Object)id));
    }

    @Override
    public Scope queryByCode(String code) {
        return (Scope)this.baseDao.getObjectByHQL("from Scope where state != '3' and code = ?", (Object[])new String[]{code});
    }

    @Override
    public List<String> getClientScopeId(String clientId) {
        String sql = "select id from t_oauth_scope s where s.id in (select scope_id from t_oauth_third_client_scope tcs where tcs.client_id = ?) and s.state != '3'";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{clientId}, null);
    }

    @Override
    public List<Scope> queryAll() {
        return this.baseDao.getListByHQL("from Scope where state != '3'", null);
    }

    @Override
    public List<Scope> queryScopeByType(String scopeType) {
        return this.baseDao.getListByHQL("from Scope where state != '3' and scopeType = ?", (Object[])new String[]{scopeType});
    }

    @Override
    public List<String> getScopeResourceIdsByType(String id, String type) {
        String sql = "select res_id from T_OAUTH_RES_SCOPE rs where rs.scope_id = ? and rs.type = ?";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{id, type}, null);
    }

    @Override
    public void deleteScopeResource(String scopeId) {
        this.baseDao.updateBySql("delete from T_OAUTH_RES_SCOPE where scope_id = ?", (Object[])new String[]{scopeId});
    }

    @Override
    public void empower(List<ResourceScope> resourceScopes) {
        this.baseDao.createBatch(resourceScopes);
    }

    @Override
    public List<PersonInfoResource> getPersonInfoResourceOfScope(List<String> scopeIds) {
        StringBuilder sb = new StringBuilder("select * from T_OAUTH_PERSON_INFO_RES pr, T_OAUTH_RES_SCOPE rs where rs.TYPE= '1' and rs.RES_ID = pr.id and rs.SCOPE_ID in (");
        for (int i = 0; i < scopeIds.size(); ++i) {
            String s = scopeIds.get(i);
            if (i == 0) {
                sb.append("'").append(s).append("'");
                continue;
            }
            sb.append(",'").append(s).append("'");
        }
        sb.append(")");
        return this.baseDao.getListBySQL(sb.toString(), null, PersonInfoResource.class);
    }

    @Override
    public void setScopeResource(ScopeBean scope) {
        if ("1".equals(scope.getScopeType())) {
            String sql = "select * from T_OAUTH_PERSON_INFO_RES pr, T_OAUTH_RES_SCOPE rs where rs.TYPE= '1' and rs.RES_ID = pr.id and rs.SCOPE_ID = ?";
            List list = this.baseDao.getListBySQL(sql, new Object[]{scope.getId()}, PersonInfoResource.class);
            if (list != null) {
                scope.setPlist(list);
            }
        } else {
            String sql = "select * from T_OAUTH_INTERFACE_RES ir, T_OAUTH_RES_SCOPE rs where rs.TYPE= '2' and rs.RES_ID = ir.id and rs.SCOPE_ID = ?";
            List list = this.baseDao.getListBySQL(sql, new Object[]{scope.getId()}, InterfaceResource.class);
            if (list != null) {
                scope.setiList(list);
            }
        }
    }
}

