/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.oauth.bean.ThirdClientBean;
import pams.function.oauth.dao.ThirdClientDao;
import pams.function.oauth.entity.Scope;
import pams.function.oauth.entity.ThirdClientInfo;
import pams.function.oauth.entity.ThirdClientScope;

@Repository
public class ThirdClientDaoImpl
implements ThirdClientDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<ThirdClientInfo> list(ThirdClientBean thirdClientBean, Page page) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> param = new ArrayList<String>();
        sql.append("from ThirdClientInfo where state != '3'");
        if (StringUtils.isNotBlank((CharSequence)thirdClientBean.getClientName())) {
            sql.append(" and clientName like ?");
            param.add("%" + thirdClientBean.getClientName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)thirdClientBean.getGrantType())) {
            sql.append(" and grantType like ?");
            param.add("%" + thirdClientBean.getGrantType() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)thirdClientBean.getState())) {
            sql.append(" and state = ?");
            param.add(thirdClientBean.getState());
        }
        String selectCount = "select count(*) " + sql;
        sql.append("order by updateTime desc");
        return this.baseDao.getListByHQL(selectCount, sql.toString(), param.toArray(), page);
    }

    @Override
    public void save(ThirdClientInfo thirdClientInfo) {
        this.baseDao.create((Object)thirdClientInfo);
    }

    @Override
    public void update(ThirdClientInfo thirdClientInfo) {
        this.baseDao.update((Object)thirdClientInfo);
    }

    @Override
    public ThirdClientInfo queryById(String clientId) {
        return (ThirdClientInfo)this.baseDao.getObjectById(ThirdClientInfo.class, (Serializable)((Object)clientId));
    }

    @Override
    public void deleteClientScope(String clientId) {
        this.baseDao.updateBySql("delete from t_oauth_third_client_scope where client_id = ?", (Object[])new String[]{clientId});
    }

    @Override
    public void empower(List<ThirdClientScope> clientScopeList) {
        this.baseDao.createBatch(clientScopeList);
    }

    @Override
    public void updateClientScope(String clientId, String grantType) {
        List<String> grantTypes = Arrays.asList(grantType.split(","));
        ArrayList<String> nameKeys = new ArrayList<String>();
        nameKeys.add("grantTypes");
        String sql = "delete from t_oauth_third_client_scope where client_id = ? and scope_id not in (select s.id from t_oauth_scope s where s.scope_type in (:grantTypes))";
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(clientId);
        param.add(grantTypes);
        this.baseDao.updateBySql(sql, param.toArray(), nameKeys);
    }

    @Override
    public ThirdClientInfo queryByIdAndSecret(String clientId, String clientSecret) {
        return (ThirdClientInfo)this.baseDao.getObjectByHQL("from ThirdClientInfo where clientId = ? and clientSecret = ? and state <> '3' and state <> '2'", (Object[])new String[]{clientId, clientSecret});
    }

    @Override
    public List<Scope> getScopeByClientId(String clientId) {
        String sql = "select * from T_OAUTH_SCOPE sc, T_OAUTH_THIRD_CLIENT_SCOPE tc where sc.SCOPE_TYPE = '1' and tc.SCOPE_ID = sc.id and tc.CLIENT_ID = ?";
        return this.baseDao.getListBySQL(sql, new Object[]{clientId}, Scope.class);
    }
}

