/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.schedule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import pams.function.oauth.service.OAuthCodeService;
import pams.function.oauth.service.OAuthTokenService;

@Component
public class DelTask {
    private static final Logger log = LoggerFactory.getLogger(DelTask.class);
    @Autowired
    private OAuthCodeService oAuthCodeService;
    @Autowired
    private OAuthTokenService oAuthTokenService;

    @Scheduled(cron="0 0 23 * * ?")
    public void delCodeAndToken() {
        try {
            Boolean tableExist = this.oAuthCodeService.checkTableExist();
            if (tableExist.booleanValue()) {
                this.oAuthCodeService.delExpiredCode();
                this.oAuthTokenService.delExpiredRefreshToken();
                this.oAuthTokenService.delExpireToken();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

