/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.service.impl;

import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.oauth.dao.OAuthCodeDao;
import pams.function.oauth.entity.OAuthCode;
import pams.function.oauth.service.OAuthCodeService;

@Service
public class OAuthCodeServiceImpl
implements OAuthCodeService {
    @Autowired
    private OAuthCodeDao oAuthCodeDao;

    @Override
    @Transactional
    public void add(OAuthCode oAuthCode) {
        this.oAuthCodeDao.insert(oAuthCode);
    }

    @Override
    public OAuthCode queryByCode(String code) {
        return this.oAuthCodeDao.queryByCode(code);
    }

    @Override
    public OAuthCode queryByCodeAndClientId(String code, String clientId) {
        return this.oAuthCodeDao.queryByCodeAndClientId(code, clientId);
    }

    @Override
    @Transactional
    public void revokeCode(OAuthCode oAuthCode) {
        oAuthCode.setIsUsed("1");
        this.oAuthCodeDao.update(oAuthCode);
    }

    @Override
    @Transactional
    public void update(OAuthCode oAuthCode) {
        this.oAuthCodeDao.update(oAuthCode);
    }

    @Override
    @Transactional
    public void delExpiredCode() {
        this.oAuthCodeDao.delExpiredCode();
    }

    @Override
    public Boolean checkTableExist() {
        BigDecimal count = this.oAuthCodeDao.queryByTableName();
        return count != null && count.intValue() > 0;
    }
}

