/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.service.impl;

import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.oauth.bean.OAuthBean;
import pams.function.oauth.bean.OAuthException;
import pams.function.oauth.bean.ScopeBean;
import pams.function.oauth.bean.ThirdClientBean;
import pams.function.oauth.entity.OAuthCode;
import pams.function.oauth.entity.Scope;
import pams.function.oauth.service.OAuthCodeService;
import pams.function.oauth.service.OAuthService;
import pams.function.oauth.service.ScopeService;
import pams.function.oauth.service.ThirdClientService;
import pams.function.oauth.utils.OAssert;

@Service
public class OAuthServiceImpl
implements OAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthServiceImpl.class);
    @Autowired
    private ThirdClientService thirdClientService;
    @Autowired
    private ScopeService scopeService;
    @Autowired
    private OAuthCodeService oAuthCodeService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    @Override
    public Map<String, Object> toAuthorizePage(OAuthBean bean) {
        ThirdClientBean client = this.thirdClientService.getById(bean.getClient_id());
        OAssert.state("code".equals(bean.getResponse_type()), "\u8bf7\u6c42\u7c7b\u578b\u9519\u8bef");
        OAssert.state(client != null, "\u7b2c\u4e09\u65b9\u4e0d\u5b58\u5728");
        OAssert.state(!"3".equals(client.getState()), "\u7b2c\u4e09\u65b9\u4e0d\u5b58\u5728");
        OAssert.state(!"2".equals(client.getState()), "\u7b2c\u4e09\u65b9\u4e0d\u53ef\u7528");
        String scopeRequest = bean.getScope();
        OAssert.state(Strings.isNotEmpty((String)scopeRequest), "\u8bf7\u6c42\u7684scope\u5f02\u5e38");
        List<Scope> clientScopes = this.thirdClientService.queryCilentScope(bean.getClient_id());
        OAssert.state(clientScopes != null && !clientScopes.isEmpty(), "\u7b2c\u4e09\u65b9\u6ca1\u6709\u6743\u9650");
        this.checkRedirectUri(bean.getRedirect_uri(), client.getClientUrl());
        List<Scope> requestScopeResult = this.checkRequestScopIsClientHas(clientScopes, scopeRequest.split(","));
        List<ScopeBean> scopeBeans = this.scopeService.transScopeBean(requestScopeResult);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("authorityInfo", scopeBeans);
        result.put("client", client);
        return result;
    }

    private void checkRedirectUri(String redirectUri, String clientUrl) {
        OAssert.state(Strings.isNotEmpty((String)redirectUri), "redirect_uri\u4e0d\u80fd\u7a7a");
        try {
            String uri = URLDecoder.decode(redirectUri, "UTF-8");
            if (uri.matches(".*(\\?+|#+|&+).*")) {
                throw new OAuthException("redirect_uri\u4e0d\u5408\u6cd5");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (Strings.isNotEmpty((String)clientUrl)) {
            OAssert.state(redirectUri.startsWith(clientUrl), "redirect_uri\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
    }

    private List<Scope> checkRequestScopIsClientHas(List<Scope> clientScopes, String[] scopeRequestArr) {
        ArrayList<Scope> list = new ArrayList<Scope>();
        for (String scopeRequestItem : scopeRequestArr) {
            boolean isCloud = false;
            for (Scope clientScopeItem : clientScopes) {
                if (!scopeRequestItem.equalsIgnoreCase(clientScopeItem.getCode())) continue;
                list.add(clientScopeItem);
                isCloud = true;
            }
            if (isCloud) continue;
            throw new OAuthException("\u7b2c\u4e09\u65b9\u4e0d\u5177\u6709" + scopeRequestItem + "\u6743\u9650");
        }
        return list;
    }

    @Override
    public String createCode(String clientId, String personId, String scopes) {
        long codeExpireMunite;
        String expireMinute = this.systemConfigPbService.getValueByCode("CODE_EXPIREIN");
        try {
            codeExpireMunite = Long.parseLong(expireMinute);
            if (codeExpireMunite <= 0L) {
                throw new Exception("code\u6709\u6548\u671f\u8bbe\u7f6e\u6709\u95ee\u9898");
            }
        }
        catch (Exception e) {
            LOGGER.error("{}", (Object)e.getMessage());
            codeExpireMunite = 5L;
        }
        try {
            long expire = System.currentTimeMillis() + codeExpireMunite * 60L * 1000L;
            String code = UUIDUtil.random();
            OAuthCode oAuthCode = new OAuthCode();
            oAuthCode.setClientId(clientId);
            oAuthCode.setIsUsed("0");
            oAuthCode.setPersonId(personId);
            oAuthCode.setExpire(expire);
            oAuthCode.setCode(code);
            oAuthCode.setScopeId(scopes);
            this.oAuthCodeService.add(oAuthCode);
            return code;
        }
        catch (Exception e) {
            return null;
        }
    }
}

