/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.oauth.bean.PersonInfoBean;
import pams.function.oauth.bean.PersonInfoTypeEnum;
import pams.function.oauth.bean.TokenBean;
import pams.function.oauth.dao.RefreshTokenDao;
import pams.function.oauth.dao.ResourcesDao;
import pams.function.oauth.dao.UserTokenDao;
import pams.function.oauth.entity.OAuthCode;
import pams.function.oauth.entity.PersonInfoResource;
import pams.function.oauth.entity.RefreshToken;
import pams.function.oauth.entity.UserToken;
import pams.function.oauth.service.OAuthTokenService;
import pams.function.oauth.service.ResourcesService;

@Service
public class OAuthTokenServiceImpl
implements OAuthTokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthTokenServiceImpl.class);
    @Autowired
    private UserTokenDao userTokenDao;
    @Autowired
    private RefreshTokenDao refreshTokenDao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ResourcesService resourcesService;
    @Autowired
    private ResourcesDao resourcesDao;
    @Autowired
    private CommonCodeService commonCodeService;

    @Override
    @Transactional
    public TokenBean createToken(OAuthCode oAuthCode) {
        UserToken userToken = new UserToken();
        userToken.setClientId(oAuthCode.getClientId());
        userToken.setPersonId(oAuthCode.getPersonId());
        userToken.setScopeId(oAuthCode.getScopeId());
        userToken.setToken(Util.getUUID());
        String tokenExpire = this.systemConfigService.getValueByCode("token_expire_in");
        long tokenExpireLong = 0x6DDD00L;
        if (StringUtils.isNotBlank((CharSequence)tokenExpire)) {
            try {
                tokenExpireLong = Long.parseLong(tokenExpire) * 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.error("token\u5931\u6548\u65f6\u95f4\u914d\u7f6e\u4e0d\u6b63\u786e", (Throwable)e);
            }
        }
        userToken.setExpire(System.currentTimeMillis() + tokenExpireLong);
        this.userTokenDao.add(userToken);
        RefreshToken refreshToken = new RefreshToken();
        refreshToken.setTokenId(userToken.getId());
        String refreshTokenExpire = this.systemConfigService.getValueByCode("refresh_token_expire_in");
        long refreshTokenExpireLong = 259200000L;
        if (StringUtils.isNotBlank((CharSequence)refreshTokenExpire)) {
            try {
                refreshTokenExpireLong = Long.parseLong(refreshTokenExpire) * 24L * 60L * 60L * 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.error("refresh_token\u5931\u6548\u65f6\u95f4\u914d\u7f6e\u4e0d\u6b63\u786e", (Throwable)e);
            }
        }
        refreshToken.setExpire(System.currentTimeMillis() + refreshTokenExpireLong);
        refreshToken.setRefreshToken(Util.getUUID());
        this.refreshTokenDao.add(refreshToken);
        return new TokenBean(userToken.getToken(), refreshToken.getRefreshToken(), userToken.getExpire(), userToken.getPersonId());
    }

    @Override
    public UserToken queryByToken(String token) {
        return this.userTokenDao.queryByToken(token);
    }

    @Override
    public PersonInfoBean queryUserInfo(String scopeIds, Person person) {
        String sql;
        PersonInfoBean personInfoBean = new PersonInfoBean();
        List<PersonInfoResource> userResources = this.resourcesService.queryUserResByScopeIds(scopeIds);
        StringBuilder personInfoSql = new StringBuilder();
        StringBuilder depInfoSql = new StringBuilder();
        StringBuilder deviceInfoSql = new StringBuilder();
        StringBuilder appInfoSql = new StringBuilder();
        for (PersonInfoResource personInfoResource : userResources) {
            if (PersonInfoTypeEnum.PERSON.getCode().equals(personInfoResource.getType())) {
                personInfoSql.append(" ").append(personInfoResource.getColumnName()).append(" as ").append("\"").append(personInfoResource.getAlign()).append("\"").append(",");
            }
            if (PersonInfoTypeEnum.DEP.getCode().equals(personInfoResource.getType())) {
                depInfoSql.append(" ").append(personInfoResource.getColumnName()).append(" as ").append("\"").append(personInfoResource.getAlign()).append("\"").append(",");
            }
            if (PersonInfoTypeEnum.DEVICE.getCode().equals(personInfoResource.getType())) {
                deviceInfoSql.append(" ").append(personInfoResource.getColumnName()).append(" as ").append("\"").append(personInfoResource.getAlign()).append("\"").append(",");
            }
            if (!PersonInfoTypeEnum.APP.getCode().equals(personInfoResource.getType())) continue;
            appInfoSql.append(" ").append(personInfoResource.getColumnName()).append(" as ").append("\"").append(personInfoResource.getAlign()).append("\"").append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)personInfoSql)) {
            personInfoSql.insert(0, "select ");
            sql = personInfoSql.substring(0, personInfoSql.length() - 1);
            sql = sql + " from t_person where flag = '0' and id = '" + person.getId() + "'";
            List<Map<String, Object>> personInfo = this.resourcesDao.queryBySql(sql);
            if (!CollectionUtils.isEmpty(personInfo)) {
                personInfoBean.setPersonInfo(personInfo.get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)depInfoSql)) {
            depInfoSql.insert(0, "select ");
            sql = depInfoSql.substring(0, depInfoSql.length() - 1);
            sql = sql + " from t_department where flag = '0' and id = (select dep_id from t_person where id = '" + person.getId() + "')";
            List<Map<String, Object>> depInfo = this.resourcesDao.queryBySql(sql);
            if (!CollectionUtils.isEmpty(depInfo)) {
                personInfoBean.setDepInfo(depInfo.get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)deviceInfoSql)) {
            deviceInfoSql.insert(0, "select ");
            sql = deviceInfoSql.substring(0, deviceInfoSql.length() - 1);
            sql = sql + " from t_device where state = '3' and person_id = '" + person.getId() + "'";
            List<Map<String, Object>> deviceInfo = this.resourcesDao.queryBySql(sql);
            if (!CollectionUtils.isEmpty(deviceInfo)) {
                personInfoBean.setDeviceInfo(deviceInfo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)appInfoSql)) {
            try {
                appInfoSql.insert(0, "select ");
                sql = appInfoSql.substring(0, appInfoSql.length() - 1);
                Set<String> appIdList = this.queryPersonAppId(person);
                if (!CollectionUtils.isEmpty(appIdList)) {
                    String appIds = Util.listToString(new ArrayList<String>(appIdList));
                    List<Map<String, Object>> appInfo = this.resourcesDao.queryBySql(sql = sql + "from t_app where app_id in (" + appIds + ")");
                    if (!CollectionUtils.isEmpty(appInfo)) {
                        personInfoBean.setAppInfo(appInfo);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return personInfoBean;
    }

    @Override
    public RefreshToken queryRefreshToken(String refreshToken) {
        return this.refreshTokenDao.queryByRefreshToken(refreshToken);
    }

    @Override
    @Transactional
    public TokenBean delayToken(RefreshToken refreshToken) {
        UserToken userToken = this.userTokenDao.queryById(refreshToken.getTokenId());
        if (userToken == null) {
            throw new RuntimeException("refreshToken\u5bf9\u5e94\u7684token\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String tokenExpire = this.systemConfigService.getValueByCode("token_expire_in");
        userToken.setToken(Util.getUUID());
        long tokenExpireLong = 0x6DDD00L;
        if (StringUtils.isNotBlank((CharSequence)tokenExpire)) {
            tokenExpireLong = Long.parseLong(tokenExpire) * 1000L;
        }
        userToken.setExpire(System.currentTimeMillis() + tokenExpireLong);
        this.userTokenDao.update(userToken);
        return new TokenBean(userToken.getToken(), refreshToken.getRefreshToken(), userToken.getExpire(), userToken.getPersonId());
    }

    @Override
    @Transactional
    public void delExpiredRefreshToken() {
        this.refreshTokenDao.deleteExpiredRefreshToken();
    }

    @Override
    @Transactional
    public void delExpireToken() {
        this.userTokenDao.deleteUserToken();
    }

    private Set<String> queryPersonAppId(Person person) {
        ArrayList<String> types = new ArrayList<String>();
        List list = this.commonCodeService.queryByType("appusearea");
        for (CommonCode code : list) {
            types.add(code.getCode());
        }
        List<String> appIds = this.resourcesDao.queryAppUserAreaByPersonId(person, types.toArray(new String[0]));
        Set<String> defaultAppIds = this.queryDefaultLimits();
        defaultAppIds.addAll(appIds);
        return defaultAppIds;
    }

    private Set<String> queryDefaultLimits() {
        List codes = this.commonCodeService.queryByType("appLimitDefault");
        HashSet<String> defaultLimits = new HashSet<String>();
        for (CommonCode commonCode : codes) {
            String packageName;
            List<String> appIds;
            if (!"1".equals(commonCode.getStatus()) || CollectionUtils.isEmpty(appIds = this.resourcesDao.queryAppIdByPackageName(packageName = commonCode.getName()))) continue;
            defaultLimits.addAll(appIds);
        }
        return defaultLimits;
    }
}

