/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.util.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import pams.function.oauth.dao.ResourcesDao;
import pams.function.oauth.entity.InterfaceResource;
import pams.function.oauth.entity.PersonInfoResource;
import pams.function.oauth.service.ResourcesService;

@Service
public class ResourcesServiceImpl
implements ResourcesService {
    @Autowired
    private ResourcesDao resourcesDao;

    @Override
    public Map<String, Object> pageInterfaceSource(String name, int pageNo, int pageSize) {
        Page page = new Page();
        page.setRp(pageSize);
        page.setPage(pageNo);
        List<InterfaceResource> list = this.resourcesDao.pageInterfaces(name, page);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", page.getTotal());
        result.put("rows", list);
        return result;
    }

    @Override
    public Map<String, Object> pagePersonInfoSource(String name, String type, int pageNo, int pageSize) {
        Page page = new Page();
        page.setRp(pageSize);
        page.setPage(pageNo);
        List<PersonInfoResource> list = this.resourcesDao.pagePersonInfo(name, type, page);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", page.getTotal());
        result.put("rows", list);
        return result;
    }

    @Override
    public InterfaceResource getInterFaceById(String id) {
        return this.resourcesDao.getInterfaceById(id);
    }

    @Override
    public PersonInfoResource getPersonInfoById(String id) {
        return this.resourcesDao.getPersonInfoById(id);
    }

    @Override
    @Transactional
    public void addOrEditInterface(InterfaceResource resource, String ctx) throws Exception {
        Assert.state((resource != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef");
        Assert.hasText((String)resource.getName(), (String)"\u63a5\u53e3\u540d\u79f0\u4e0d\u53ef\u7a7a");
        Assert.hasText((String)resource.getUri(), (String)"\u63a5\u53e3\u8def\u5f84\u4e0d\u53ef\u7a7a");
        Assert.state((boolean)resource.getUri().startsWith(ctx), (String)("uri\u8bf7\u4ee5" + ctx + "\u5f00\u5934"));
        if (Strings.isNotEmpty((String)resource.getId())) {
            resource.setState("1");
            this.resourcesDao.updateInterface(resource);
        } else {
            resource.setState("1");
            this.resourcesDao.addInterface(resource);
        }
    }

    @Override
    @Transactional
    public void addOrEditPersonInfo(PersonInfoResource resource) throws Exception {
        Assert.state((resource != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef");
        Assert.hasText((String)resource.getColumnName(), (String)"\u5b57\u6bb5\u540d\u4e0d\u53ef\u7a7a");
        Assert.hasText((String)resource.getName(), (String)"\u8d44\u6e90\u540d\u79f0\u4e0d\u53ef\u7a7a");
        Assert.hasText((String)resource.getAlign(), (String)"\u8d44\u6e90\u522b\u540d\u4e0d\u53ef\u7a7a");
        if (Strings.isEmpty((String)resource.getId())) {
            Assert.state((this.resourcesDao.countColumn(resource.getColumnName(), resource.getType()) < 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u7c7b\u578b\u5b57\u6bb5\u91cd\u590d");
            Assert.state((this.resourcesDao.alignCount(resource.getAlign()) < 1 ? 1 : 0) != 0, (String)"\u522b\u540d\u4e0d\u53ef\u91cd\u590d");
        }
        if (Strings.isNotEmpty((String)resource.getId())) {
            PersonInfoResource personInfoResource = this.resourcesDao.getPersonInfoById(resource.getId());
            Assert.state((personInfoResource != null ? 1 : 0) != 0, (String)"\u4fe1\u606f\u5f02\u5e38");
            if (!personInfoResource.getAlign().equals(resource.getAlign())) {
                Assert.state((this.resourcesDao.alignCount(resource.getAlign()) < 1 ? 1 : 0) != 0, (String)"\u522b\u540d\u4e0d\u53ef\u91cd\u590d");
            }
            if (!personInfoResource.getColumnName().equals(resource.getColumnName()) || !personInfoResource.getType().equals(resource.getType())) {
                Assert.state((this.resourcesDao.countColumn(resource.getColumnName(), resource.getType()) < 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u7c7b\u578b\u5b57\u6bb5\u91cd\u590d");
            }
            personInfoResource.setAlign(resource.getAlign());
            personInfoResource.setColumnName(resource.getColumnName());
            personInfoResource.setDesc(resource.getDesc());
            personInfoResource.setName(resource.getName());
            personInfoResource.setType(resource.getType());
            this.resourcesDao.updatePersonInfo(personInfoResource);
        } else {
            this.resourcesDao.addPersonInfo(resource);
        }
    }

    @Override
    public List<Map<String, String>> getColumnInfo(String type) throws Exception {
        String table = "";
        if ("1".equals(type)) {
            table = "T_PERSON";
        } else if ("2".equals(type)) {
            table = "T_DEPARTMENT";
        } else if ("3".equals(type)) {
            table = "T_DEVICE";
        } else if ("4".equals(type)) {
            table = "T_APP";
        } else {
            Assert.state((boolean)false, (String)"\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        return this.resourcesDao.getColumns(table);
    }

    @Override
    @Transactional
    public void changeInterfaceState(String id, String state) {
        InterfaceResource resource = this.resourcesDao.getInterfaceById(id);
        if (resource == null) {
            throw new RuntimeException("\u6ca1\u6709\u8bb0\u5f55");
        }
        resource.setState(state);
        this.resourcesDao.updateInterface(resource);
    }

    @Override
    @Transactional
    public void deletePersonInfo(String id) {
        this.resourcesDao.deletePersonInfo(id);
    }

    @Override
    public List<PersonInfoResource> queryPersonResByType(String type) {
        return this.resourcesDao.queryPersonResByType(type);
    }

    @Override
    public List<InterfaceResource> queryAllInterfaceRes() {
        return this.resourcesDao.queryAllInterfaceRes();
    }

    @Override
    public List<PersonInfoResource> queryUserResByScopeIds(String scopeIds) {
        return this.resourcesDao.queryUserResByScopeIds(scopeIds);
    }
}

