/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.service.CommonCodeService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.oauth.bean.GrantTypeEnum;
import pams.function.oauth.bean.ScopeBean;
import pams.function.oauth.dao.ScopeDao;
import pams.function.oauth.entity.PersonInfoResource;
import pams.function.oauth.entity.ResourceScope;
import pams.function.oauth.entity.Scope;
import pams.function.oauth.service.ResourcesService;
import pams.function.oauth.service.ScopeService;
import pams.function.oauth.service.ThirdClientService;

@Service
public class ScopeServiceImpl
implements ScopeService {
    @Autowired
    private ScopeDao scopeDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private ThirdClientService thirdClientService;
    @Autowired
    private ResourcesService resourcesService;

    @Override
    public List<ScopeBean> list(ScopeBean scopeBean, Page page) {
        List<Scope> scopeList = this.scopeDao.list(scopeBean, page);
        return this.transferToBeanList(scopeList);
    }

    @Override
    @Transactional
    public void add(ScopeBean scopeBean) {
        Scope scope = new Scope();
        if (this.checkCode(scopeBean.getCode())) {
            throw new RuntimeException("code\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        scope.setCode(scopeBean.getCode());
        scope.setCreateBy(scopeBean.getCreateBy());
        scope.setCreateTime(System.currentTimeMillis());
        scope.setScopeType(scopeBean.getScopeType());
        scope.setUpdateBy(scopeBean.getCreateBy());
        scope.setUpdateTime(System.currentTimeMillis());
        scope.setDetail(scopeBean.getDetail());
        scope.setName(scopeBean.getName());
        scope.setState("1");
        this.scopeDao.add(scope);
    }

    private boolean checkCode(String code) {
        return this.scopeDao.queryByCode(code) != null;
    }

    @Override
    @Transactional
    public void update(ScopeBean scopeBean) {
        Scope scope = this.scopeDao.queryById(scopeBean.getId());
        if (scope == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u8be5\u6761\u8bb0\u5f55");
        }
        scope.setName(scopeBean.getName());
        scope.setDetail(scopeBean.getDetail());
        scope.setUpdateTime(System.currentTimeMillis());
        scope.setUpdateBy(scopeBean.getUpdateBy());
        this.scopeDao.update(scope);
    }

    @Override
    public ScopeBean queryById(String id) {
        Scope scope = this.scopeDao.queryById(id);
        return this.transferToBean(scope);
    }

    private ScopeBean transferToBean(Scope scope) {
        ScopeBean scopeBean = null;
        if (scope != null) {
            scopeBean = new ScopeBean();
            BeanUtils.copyProperties((Object)scope, (Object)scopeBean);
            Person person = this.userManageService.getPersonByPersonId(scope.getCreateBy());
            if (person != null) {
                scopeBean.setCreatorName(person.getName());
            }
            String codeName = GrantTypeEnum.getNameByCode(scope.getScopeType());
            scopeBean.setScopeTypeName(codeName);
        }
        return scopeBean;
    }

    private List<ScopeBean> transferToBeanList(List<Scope> scopeList) {
        ArrayList<ScopeBean> scopeBeanList = new ArrayList<ScopeBean>();
        for (Scope scope : scopeList) {
            scopeBeanList.add(this.transferToBean(scope));
        }
        return scopeBeanList;
    }

    @Override
    @Transactional
    public void updateState(ScopeBean scopeBean) {
        Scope scope = this.scopeDao.queryById(scopeBean.getId());
        if (scope == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u8be5\u6761\u8bb0\u5f55");
        }
        scope.setState(scopeBean.getState());
        scope.setUpdateBy(scopeBean.getUpdateBy());
        this.scopeDao.update(scope);
    }

    @Override
    @Transactional
    public void delete(String id, String operator) {
        Scope scope = this.scopeDao.queryById(id);
        if (scope == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u8be5\u6761\u8bb0\u5f55");
        }
        this.scopeDao.deleteScopeResource(id);
        scope.setUpdateBy(operator);
        scope.setUpdateTime(System.currentTimeMillis());
        scope.setState("3");
        this.scopeDao.update(scope);
    }

    @Override
    public List<String> getClientScopeId(String clientId) {
        return this.scopeDao.getClientScopeId(clientId);
    }

    @Override
    public List<ScopeBean> queryScopeByType(String type) {
        List<Scope> scopes = this.scopeDao.queryScopeByType(type);
        return this.transferToBeanList(scopes);
    }

    @Override
    public List<String> getScopeResourceIdsByType(String id, String type) {
        return this.scopeDao.getScopeResourceIdsByType(id, type);
    }

    @Override
    @Transactional
    public void empower(String scopeId, String resourceIds, String type) {
        String[] resourceId = resourceIds.split(",");
        ArrayList<ResourceScope> resourceScopes = new ArrayList<ResourceScope>();
        for (String id : resourceId) {
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            ResourceScope resourceScope = new ResourceScope();
            resourceScope.setResId(id);
            resourceScope.setScopeId(scopeId);
            resourceScope.setType(type);
            resourceScopes.add(resourceScope);
        }
        this.scopeDao.deleteScopeResource(scopeId);
        if (!CollectionUtils.isEmpty(resourceScopes)) {
            this.scopeDao.empower(resourceScopes);
        }
    }

    @Override
    public List<PersonInfoResource> getPersonInfoResOfScope(List<Scope> list) {
        return this.scopeDao.getPersonInfoResourceOfScope(this.getScopeIds(list));
    }

    private List<String> getScopeIds(List<Scope> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (Scope s : list) {
            result.add(s.getId());
        }
        return result;
    }

    @Override
    public List<ScopeBean> transScopeBean(List<Scope> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScopeBean> result = new ArrayList<ScopeBean>();
        for (Scope scope : list) {
            ScopeBean sb = new ScopeBean();
            BeanUtils.copyProperties((Object)scope, (Object)sb);
            this.scopeDao.setScopeResource(sb);
            result.add(sb);
        }
        return result;
    }
}

