/*
 * Decompiled with CFR 0.152.
 */
package pams.function.oauth.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.oauth.bean.GrantTypeEnum;
import pams.function.oauth.bean.ThirdClientBean;
import pams.function.oauth.dao.ThirdClientDao;
import pams.function.oauth.entity.Scope;
import pams.function.oauth.entity.ThirdClientInfo;
import pams.function.oauth.entity.ThirdClientScope;
import pams.function.oauth.service.ThirdClientService;

@Service
public class ThirdClientServiceImpl
implements ThirdClientService {
    private static final Logger log = LoggerFactory.getLogger(ThirdClientServiceImpl.class);
    @Autowired
    private ThirdClientDao thirdClientDao;
    @Autowired
    private UserManageService userManageService;

    @Override
    public List<ThirdClientBean> list(ThirdClientBean thirdClientBean, Page page) {
        List<ThirdClientInfo> thirdClientInfoList = this.thirdClientDao.list(thirdClientBean, page);
        ArrayList<ThirdClientBean> thirdClientBeanList = new ArrayList<ThirdClientBean>();
        for (ThirdClientInfo thirdClientInfo : thirdClientInfoList) {
            ThirdClientBean bean = this.transferToBean(thirdClientInfo);
            thirdClientBeanList.add(bean);
        }
        return thirdClientBeanList;
    }

    private ThirdClientBean transferToBean(ThirdClientInfo thirdClientInfo) {
        String[] grantType;
        Person updatePerson;
        if (thirdClientInfo == null) {
            return null;
        }
        ThirdClientBean bean = new ThirdClientBean();
        BeanUtils.copyProperties((Object)thirdClientInfo, (Object)bean);
        Person creator = this.userManageService.queryPersonById(thirdClientInfo.getCreateBy());
        if (creator != null) {
            bean.setCreatorName(creator.getName());
        }
        if ((updatePerson = this.userManageService.queryPersonById(thirdClientInfo.getUpdateBy())) != null) {
            bean.setUpdateName(updatePerson.getName());
        }
        StringBuilder grantTypeName = new StringBuilder();
        for (String type : grantType = thirdClientInfo.getGrantType().split(",")) {
            grantTypeName.append(GrantTypeEnum.getNameByCode(type)).append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)grantTypeName)) {
            bean.setGrantTypeName(grantTypeName.substring(0, grantTypeName.length() - 1));
        }
        return bean;
    }

    @Override
    @Transactional
    public void add(ThirdClientBean thirdClientBean) {
        ThirdClientInfo thirdClientInfo = new ThirdClientInfo();
        thirdClientInfo.setClientName(thirdClientBean.getClientName());
        thirdClientInfo.setClientSecret(Util.getUUID());
        thirdClientInfo.setClientUrl(thirdClientBean.getClientUrl());
        thirdClientInfo.setCreateBy(thirdClientBean.getCreateBy());
        thirdClientInfo.setUpdateBy(thirdClientBean.getCreateBy());
        thirdClientInfo.setGrantType(thirdClientBean.getGrantType());
        thirdClientInfo.setState("1");
        thirdClientInfo.setCreateTime(System.currentTimeMillis());
        thirdClientInfo.setUpdateTime(System.currentTimeMillis());
        this.thirdClientDao.save(thirdClientInfo);
    }

    private void updateClientScope(ThirdClientInfo thirdClientInfo, String grantType) {
        this.thirdClientDao.updateClientScope(thirdClientInfo.getClientId(), grantType);
    }

    @Override
    @Transactional
    public void update(ThirdClientBean thirdClientBean) {
        ThirdClientInfo thirdClientInfo = this.thirdClientDao.queryById(thirdClientBean.getClientId());
        if (thirdClientInfo == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u8be5\u6761\u8bb0\u5f55");
        }
        this.updateClientScope(thirdClientInfo, thirdClientBean.getGrantType());
        thirdClientInfo.setClientName(thirdClientBean.getClientName());
        thirdClientInfo.setGrantType(thirdClientBean.getGrantType());
        thirdClientInfo.setClientUrl(thirdClientBean.getClientUrl());
        thirdClientInfo.setUpdateTime(System.currentTimeMillis());
        thirdClientInfo.setUpdateBy(thirdClientBean.getUpdateBy());
        this.thirdClientDao.update(thirdClientInfo);
    }

    @Override
    public ThirdClientBean getById(String clientId) {
        return this.transferToBean(this.thirdClientDao.queryById(clientId));
    }

    @Override
    @Transactional
    public void updateState(String clientId, String state, String operator) {
        ThirdClientInfo thirdClientInfo = this.thirdClientDao.queryById(clientId);
        if (thirdClientInfo == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u8be5\u6761\u8bb0\u5f55");
        }
        thirdClientInfo.setState(state);
        thirdClientInfo.setUpdateBy(operator);
        this.thirdClientDao.update(thirdClientInfo);
    }

    @Override
    @Transactional
    public void delete(String clientId, String operator) {
        ThirdClientInfo thirdClientInfo = this.thirdClientDao.queryById(clientId);
        if (thirdClientInfo == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u8be5\u6761\u8bb0\u5f55");
        }
        this.thirdClientDao.deleteClientScope(clientId);
        thirdClientInfo.setState("3");
        thirdClientInfo.setUpdateBy(operator);
        thirdClientInfo.setUpdateTime(System.currentTimeMillis());
        this.thirdClientDao.update(thirdClientInfo);
    }

    @Override
    @Transactional
    public void empower(String clientId, String scopeIds) {
        String[] scopeId = scopeIds.split(",");
        ArrayList<ThirdClientScope> clientScopeList = new ArrayList<ThirdClientScope>();
        for (String id : scopeId) {
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            ThirdClientScope thirdClientScope = new ThirdClientScope();
            thirdClientScope.setClientId(clientId);
            thirdClientScope.setScopeId(id);
            clientScopeList.add(thirdClientScope);
        }
        this.thirdClientDao.deleteClientScope(clientId);
        if (!CollectionUtils.isEmpty(clientScopeList)) {
            this.thirdClientDao.empower(clientScopeList);
        }
    }

    @Override
    public ThirdClientBean queryByIdAndSecret(String clientId, String clientSecret) {
        ThirdClientInfo thirdClientInfo = this.thirdClientDao.queryByIdAndSecret(clientId, clientSecret);
        if (thirdClientInfo != null) {
            return this.transferToBean(thirdClientInfo);
        }
        return null;
    }

    @Override
    public List<Scope> queryCilentScope(String clientId) {
        if (Strings.isEmpty((String)clientId)) {
            return null;
        }
        return this.thirdClientDao.getScopeByClientId(clientId);
    }
}

