/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.common.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.springframework.util.StringUtils;

public class RestfulResult<T> {
    private String messageId;
    private String version;
    private String code;
    private String message;
    private T data;

    public static <T> RestfulResult<T> getInstance(String result, Class<T> clazz) {
        if (!StringUtils.hasText((String)result)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        JSONObject data = jsonObject.getJSONObject("data");
        Object d = data == null ? null : data.toJavaObject(clazz);
        return RestfulResult.create(jsonObject.getString("messageId"), jsonObject.getString("version"), jsonObject.getString("code"), jsonObject.getString("message"), d);
    }

    public static <T> RestfulResult<List<T>> getInstanceListDate(String result, Class<T> clazz) {
        if (!StringUtils.hasText((String)result)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        RestfulResult<List<List>> restfulResult = new RestfulResult<List<List>>();
        restfulResult.setCode(jsonObject.getString("code"));
        restfulResult.setMessage(jsonObject.getString("message"));
        restfulResult.setMessageId(jsonObject.getString("messageId"));
        restfulResult.setVersion(jsonObject.getString("version"));
        JSONArray arr = jsonObject.getJSONArray("data");
        if (arr == null) {
            restfulResult.setData(null);
        } else {
            restfulResult.setData(arr.toJavaList(clazz));
        }
        return restfulResult;
    }

    public static <T> RestfulResult<T> create(String messageId, String version, String code, String message, T data) {
        RestfulResult<T> restfulResult = new RestfulResult<T>();
        restfulResult.setCode(code);
        restfulResult.setMessage(message);
        restfulResult.setMessageId(messageId);
        restfulResult.setVersion(version);
        restfulResult.setData(data);
        return restfulResult;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

