/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappapply.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.resappapply.bean.AppResourceApplyBean;
import pams.function.sbma.resappapply.entity.AppResourceApply;
import pams.function.sbma.resappapply.service.AppResourceApplyService;
import pams.function.sbma.resmanager.bean.ResourceBean;

@Controller
@Scope(value="session")
public class AppResourceApplyController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppResourceApplyController.class);
    @Autowired
    private AppResourceApplyService appResourceApplyService;

    @RequestMapping(value={"/sbma/AppResourceApplyController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u5e94\u7528\u8d44\u6e90\u6388\u6743\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/AppResourceApplyController/queryList.do"})
    public void localAppResourceApplyList(AppResourceApplyBean bean, HttpServletResponse response) {
        try {
            Page page = new Page(bean.getPage(), bean.getRows());
            if (Strings.isNotEmpty((String)bean.getApplyTimeStartString())) {
                bean.setApplyTimeStart(Util.getLongDate((String)(bean.getApplyTimeEndString() + " 00:00:00")));
            }
            if (Strings.isNotEmpty((String)bean.getApplyTimeEndString())) {
                bean.setApplyTimeEnd(Util.getLongDate((String)(bean.getApplyTimeEndString() + " 23:59:59")));
            }
            List<AppResourceApply> list = this.appResourceApplyService.appResourceApplyListFromMdp(bean, page);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", page.getTotal());
            map.put("rows", list);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u6388\u6743\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/sbma/AppResourceApplyController/apply_info.do"})
    public String toApplyInfo(String applyId, ModelMap modelMap) {
        return "sbma/resappapply/default/applyInfo";
    }

    @RequestMapping(value={"/sbma/AppResourceApplyController/accredit.do"})
    public void doAccredit(String applyId, String applyDesc, String appRegionalismCode, Integer status, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (status == null) {
                throw new Exception("\u64cd\u4f5c\u72b6\u6001\u53c2\u6570\u5f02\u5e38");
            }
            this.appResourceApplyService.doAccreditToSmd(this.operator.getPerson(), applyId, status, appRegionalismCode, applyDesc);
            result.put("flag", "1");
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6388\u6743\u72b6\u6001\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            result.put("flag", "0");
            result.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/sbma/AppResourceApplyController/res_detail.do"})
    public void getResDetail(String resourceId, String resourceRegionalismCode, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (StringUtils.isEmpty((String)resourceId) || StringUtils.isEmpty((String)resourceRegionalismCode)) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            ResourceBean resource = this.appResourceApplyService.getResouceDetail(resourceId, resourceRegionalismCode);
            if (resource == null) {
                throw new Exception("\u6ca1\u6709\u83b7\u53d6\u5230\u4fe1\u606f");
            }
            map.put("res", resource);
            map.put("flag", true);
        }
        catch (Exception e) {
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

