/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resapply.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.common.service.SodService;
import pams.function.sbma.oplog.entity.OperatLog;
import pams.function.sbma.oplog.service.OperatLogService;
import pams.function.sbma.oplog.service.impl.OperatLogUtil;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.service.ResourceApplyService;
import pams.function.sbma.resmanager.bean.ResourceBean;
import pams.function.sbma.resmanager.service.ResourceService;

@Controller
@Scope(value="session")
public class ResourceApplyController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(ResourceApplyController.class);
    @Autowired
    private ResourceApplyService resourceApplyService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SodService sodService;
    @Autowired
    private OperatLogService operatLogService;
    @Autowired
    private ResourceService resourceService;

    @RequestMapping(value={"/sbma/ResourceApplyController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/queryList.do"})
    public void queryList(ResourceApplyBean queryBean, HttpServletResponse response) {
        try {
            Page page = new Page(queryBean.getPage(), queryBean.getRows());
            HashMap<String, Object> result = new HashMap<String, Object>();
            List<ResourceApplyBean> list = this.resourceApplyService.queryList(queryBean, page);
            result.put("total", page.getTotal());
            result.put("rows", list);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8fc7\u7a0b\u8d44\u6e90\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/toApproval.do"})
    public String toApproval(String resourceApplyId, ModelMap map) {
        try {
            ResourceApplyBean bean = this.resourceApplyService.queryById(resourceApplyId);
            map.put((Object)"apply", (Object)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8df3\u8f6c\u5ba1\u6838\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "sbma/resapply/default/approval";
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/toDetail.do"})
    public String toDetail(String resourceApplyId, ModelMap map) {
        try {
            ResourceApplyBean bean = this.resourceApplyService.queryById(resourceApplyId);
            map.put((Object)"apply", (Object)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8df3\u8f6c\u8be6\u60c5\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "sbma/resapply/default/detail";
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/getDrsList.do"})
    public void getDrsList(String regionalismCode, String networkCode, HttpServletResponse response) throws IOException {
        String jsonlist = "";
        try {
            List<Map<String, String>> listmap = this.sodService.getDrsList(regionalismCode, networkCode);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6drs\u5217\u8868\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)jsonlist);
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/getDetail.do"})
    public void getDetail(String resourceApplyId, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ResourceApplyBean bean = this.resourceApplyService.queryById(resourceApplyId);
            map.put("res", bean);
            map.put("flag", true);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u7533\u8bf7\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/getResourceDetail.do"})
    public void getResourceDetail(String resourceApplyId, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ResourceApplyBean bean = this.resourceApplyService.queryById(resourceApplyId);
            ResourceBean resourceBean = this.resourceService.queryById(bean.getResourceId());
            map.put("res", resourceBean);
            map.put("flag", true);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sbma/ResourceApplyController/approval.do"})
    public void approval(ResourceApplyBean queryBean, HttpServletResponse response, ModelMap map) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            String identifier = this.operator.getPerson().getIdentifier();
            queryBean.setApproverIdentifier(Strings.isEmpty((String)identifier) ? "0" : identifier);
            this.resourceApplyService.update(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u8d44\u6e90\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u5f02\u5e38");
        }
        finally {
            this.saveOperatLog(queryBean.getResourceApplyId(), "1");
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sbma/ResourceApplyController/publish.do"})
    public void publish(ResourceApplyBean queryBean, HttpServletResponse response, ModelMap map) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.resourceApplyService.publish(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u53d1\u5e03\u8d44\u6e90\u5f02\u5e38" + e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u5f02\u5e38");
        }
        finally {
            this.saveOperatLog(queryBean.getResourceApplyId(), "2");
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    private void saveOperatLog(String resourceApplyId, String type) {
        ResourceApplyBean resourceApplyBean = this.resourceApplyService.queryById(resourceApplyId);
        if (resourceApplyBean != null) {
            OperatLog operatLog = OperatLogUtil.createLog(this.operator.getPerson(), resourceApplyBean.getResourceId(), resourceApplyBean.getName(), "", "", "", resourceApplyBean.getRegionalismCode(), type);
            this.operatLogService.addOptLog(operatLog);
        }
    }
}

