/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resapply.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syn.entity.MDPPerson;
import com.xdja.pams.syn.service.PersonMDPService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.sbma.common.dao.BusinessTypeDao;
import pams.function.sbma.common.dao.RegionalismDao;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.dao.ResourceApplyDao;
import pams.function.sbma.resapply.entity.ResourceApply;
import pams.function.sbma.resapply.service.ResourceApplyService;
import pams.function.sbma.resmanager.bean.ResourceScopeBean;
import pams.function.sbma.resmanager.dao.ResourceDao;
import pams.function.sbma.resmanager.dao.ResourceScopeDao;
import pams.function.sbma.resmanager.entity.Resource;
import pams.function.sbma.resmanager.entity.SbmaResourceScope;
import pams.function.sbma.resregist.bean.ResourceContentReqBean;

@Service
public class ResourceApplyServiceImpl
implements ResourceApplyService {
    @Autowired
    private ResourceApplyDao resourceApplyDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private ResourceScopeDao resourceScopeDao;
    @Autowired
    private RegionalismDao regionalismDao;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private BusinessTypeDao businessTypeDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private PersonMDPService personMDPService;
    @Autowired
    private DepManageService depManageService;
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Logger logger = LoggerFactory.getLogger(ResourceApplyServiceImpl.class);

    @Override
    public List<ResourceApplyBean> queryList(ResourceApplyBean queryBean, Page page) {
        ArrayList<ResourceApplyBean> result = new ArrayList<ResourceApplyBean>();
        List<ResourceApply> list = this.resourceApplyDao.queryList(queryBean, page);
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        ResourceApplyBean bean = null;
        for (ResourceApply entity : list) {
            bean = new ResourceApplyBean();
            this.transBean(entity, bean);
            result.add(bean);
        }
        return result;
    }

    @Override
    public ResourceApplyBean queryById(String id) {
        ResourceApply entity = this.resourceApplyDao.queryById(id);
        if (entity == null) {
            return null;
        }
        ResourceApplyBean bean = new ResourceApplyBean();
        this.transBean(entity, bean);
        return bean;
    }

    private void transBean(ResourceApply apply, ResourceApplyBean bean) {
        BeanUtils.copyProperties((Object)apply, (Object)bean);
        String typeName = this.commonCodePbService.getCodeNameByCode(bean.getType() + "", "sbma_restype");
        bean.setTypeName(typeName);
        String resBusinessTypeName = this.businessTypeDao.getNameByCode(bean.getBusinessType());
        bean.setBusinessTypeName(resBusinessTypeName);
        bean.setOpenFlagName(this.getOpenFlagName(bean.getOpenFlag()));
        String resRegionalName = this.regionalismDao.getFullNameByCode(bean.getRegionalismCode(), " ");
        bean.setRegionalismName(resRegionalName);
        bean.setNetworkCodeName(this.getNetWorkName(bean.getNetworkCode()));
        bean.setCreateTimeShow(Util.getDate((String)FORMAT, (Date)new Date(bean.getCreateTime())));
        bean.setLastUpdateTimeShow(Util.getDate((String)FORMAT, (Date)new Date(bean.getLastUpdateTime())));
        bean.setStatusName(this.getStatusName(bean.getStatus()));
        String resouceType = "";
        if ("1".equals(apply.getResourceType())) {
            resouceType = "\u4e00\u7c7b\u8d44\u6e90";
        } else if ("2".equals(apply.getResourceType())) {
            resouceType = "\u4e8c\u7c7b\u8d44\u6e90";
        } else if ("3".equals(apply.getResourceType())) {
            resouceType = "\u4e09\u7c7b\u8d44\u6e90";
        }
        bean.setResourceTypeName(resouceType);
    }

    @Override
    @Transactional
    public void update(ResourceApplyBean bean) {
        ResourceApply entity = this.resourceApplyDao.queryById(bean.getResourceApplyId());
        if (entity == null) {
            return;
        }
        Person person = this.userManageService.queryPersonById(entity.getCreatorId());
        if (person == null) {
            MDPPerson mdpPerson = this.personMDPService.getMDPPersonById(entity.getCreatorId());
            if (mdpPerson != null) {
                if (Strings.isNotEmpty((String)mdpPerson.getServiceUnitId())) {
                    Department department = this.depManageService.queryDepById(mdpPerson.getServiceUnitId());
                    entity.setOwnerIdentifier(mdpPerson.getIdentifier());
                    entity.setOwnerDepCode(department.getCode());
                } else {
                    entity.setOwnerIdentifier(mdpPerson.getIdentifier());
                    entity.setOwnerDepCode("");
                }
            }
        } else {
            entity.setOwnerIdentifier(person.getIdentifier());
            entity.setOwnerDepCode(person.getDepartment().getCode());
        }
        entity.setApproverIdentifier(bean.getApproverIdentifier());
        entity.setAproveTime(System.currentTimeMillis());
        entity.setStatus(bean.getStatus());
        entity.setDrsId(bean.getDrsId());
        entity.setDrsName(bean.getDrsName());
        entity.setLastUpdateTime(System.currentTimeMillis());
        this.resourceApplyDao.update(entity);
    }

    @Override
    @Transactional
    public void publish(ResourceApplyBean bean) {
        Long currentTime = System.currentTimeMillis();
        ResourceApply entity = this.resourceApplyDao.queryById(bean.getResourceApplyId());
        if (entity == null || entity.getStatus() != 3) {
            return;
        }
        Resource resource = this.resourceDao.queryById(entity.getResourceId());
        if (resource == null) {
            resource = new Resource();
            BeanUtils.copyProperties((Object)entity, (Object)resource);
            resource.setCreateTime(entity.getCreateTime());
            resource.setStatus(4);
            resource.setLastUpdateTime(currentTime);
            resource.setAproveTime(System.currentTimeMillis());
            this.resourceDao.add(resource);
            SbmaResourceScope newEntity = new SbmaResourceScope();
            newEntity.setPublishNetworkCode(entity.getResourceType());
            newEntity.setPublishRegionalismCode(entity.getRegionalismCode());
            Long l = currentTime;
            Long l2 = currentTime = Long.valueOf(currentTime + 1L);
            newEntity.setLastUpdateTime(l);
            newEntity.setStatus(1);
            l = currentTime;
            l2 = currentTime = Long.valueOf(currentTime + 1L);
            newEntity.setCreateTime(l);
            newEntity.setResourceId(entity.getResourceId());
            this.resourceScopeDao.add(newEntity);
        } else {
            if (resource.getOpenFlag() == 1 && entity.getOpenFlag() == 0) {
                ResourceScopeBean queryBean = new ResourceScopeBean();
                queryBean.setResourceId(resource.getResourceId());
                List<SbmaResourceScope> oldScopes = this.resourceScopeDao.queryList(queryBean);
                for (SbmaResourceScope scope : oldScopes) {
                    if (scope.getPublishRegionalismCode().equals(entity.getRegionalismCode()) && scope.getPublishNetworkCode().equals(entity.getNetworkCode())) continue;
                    scope.setStatus(0);
                    Long l = currentTime;
                    Long l3 = currentTime = Long.valueOf(currentTime + 1L);
                    scope.setLastUpdateTime(l);
                    this.resourceScopeDao.update(scope);
                }
            }
            BeanUtils.copyProperties((Object)entity, (Object)resource);
            resource.setStatus(4);
            this.resourceDao.update(resource);
        }
        entity.setStatus(bean.getStatus());
        entity.setLastUpdateTime(currentTime);
        this.resourceApplyDao.update(entity);
    }

    @Override
    @Transactional
    public void addResourceApply(ResourceApply apply) throws Exception {
        try {
            if (Strings.isEmpty((String)apply.getResourceId())) {
                apply.setResourceId(this.createResourceId(apply));
            }
            if (!this.resourceApplyDao.addResourceApply(apply)) {
                throw new Exception("\u6dfb\u52a0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String createResourceId(ResourceApply apply) {
        StringBuilder sb = new StringBuilder();
        sb.append(apply.getRegionalismCode()).append("-").append(apply.getNetworkCode()).append("-").append(apply.getBusinessType()).append("-").append(UUIDUtil.random());
        return sb.toString();
    }

    private String getOpenFlagName(Integer openFlag) {
        if (openFlag == null) {
            return "";
        }
        int openFlagI = openFlag;
        return openFlagI == 0 ? "\u4e0d\u516c\u5f00" : (openFlagI == 1 ? "\u516c\u5f00" : "");
    }

    private String getNetWorkName(String netWorkCode) {
        if ("1".equals(netWorkCode)) {
            return "\u4e00\u7c7b";
        }
        if ("2".equals(netWorkCode)) {
            return "\u4e8c\u7c7b";
        }
        if ("3".equals(netWorkCode)) {
            return "\u4e09\u7c7b";
        }
        return "";
    }

    private String getStatusName(Integer status) {
        if (status == null) {
            return "";
        }
        int s = status;
        if (s == 0) {
            return "\u5ba1\u6838\u4e2d";
        }
        if (s == 1) {
            return "\u5df2\u62d2\u7edd";
        }
        if (s == 2) {
            return "\u672a\u6ce8\u518c";
        }
        if (s == 3) {
            return "\u5df2\u6ce8\u518c";
        }
        if (s == 4) {
            return "\u5df2\u53d1\u5e03";
        }
        return "";
    }

    @Override
    public boolean isDsNameIsExists(String dsName, String resId) {
        try {
            List<ResourceApply> list = this.resourceApplyDao.queryByDsName(dsName);
            if (list != null) {
                for (ResourceApply a : list) {
                    String c = a.getContent();
                    ResourceContentReqBean bean = (ResourceContentReqBean)JSON.parseObject((String)c, ResourceContentReqBean.class);
                    String ds = bean.getDataSource().getDsName();
                    if (!ds.equals(dsName) || a.getResourceId().equals(resId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u6570\u636e\u6e90\u540d\u79f0\u662f\u5426\u5b58\u5728\u62a5\u9519:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

