/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resmanager.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.sbma.common.dao.BusinessTypeDao;
import pams.function.sbma.common.dao.RegionalismDao;
import pams.function.sbma.resmanager.bean.ResourceBean;
import pams.function.sbma.resmanager.bean.ResourceScopeBean;
import pams.function.sbma.resmanager.dao.ResourceDao;
import pams.function.sbma.resmanager.dao.ResourceScopeDao;
import pams.function.sbma.resmanager.entity.Resource;
import pams.function.sbma.resmanager.entity.SbmaResourceScope;
import pams.function.sbma.resmanager.service.ResourceService;

@Service
public class ResourceServiceImpl
implements ResourceService {
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private RegionalismDao regionalismDao;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private BusinessTypeDao businessTypeDao;
    @Autowired
    private ResourceScopeDao resourceScopeDao;
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";

    @Override
    public List<ResourceBean> queryList(ResourceBean queryBean, Page page) {
        List<Resource> list = this.resourceDao.queryList(queryBean, page);
        ArrayList<ResourceBean> result = new ArrayList<ResourceBean>();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        ResourceBean bean = null;
        for (Resource entity : list) {
            bean = new ResourceBean();
            BeanUtils.copyProperties((Object)entity, (Object)bean);
            result.add(bean);
        }
        return result;
    }

    @Override
    public ResourceBean queryById(String resourceId) {
        Resource entity = this.resourceDao.queryById(resourceId);
        if (entity == null) {
            return null;
        }
        ResourceBean bean = new ResourceBean();
        BeanUtils.copyProperties((Object)entity, (Object)bean);
        String typeName = this.commonCodePbService.getCodeNameByCode(bean.getType() + "", "sbma_restype");
        bean.setTypeName(typeName);
        String resBusinessTypeName = this.businessTypeDao.getNameByCode(bean.getBusinessType());
        bean.setBusinessTypeName(resBusinessTypeName);
        bean.setOpenFlagName(this.getOpenFlagName(bean.getOpenFlag()));
        String resRegionalName = this.regionalismDao.getFullNameByCode(bean.getRegionalismCode(), " ");
        bean.setRegionalismName(resRegionalName);
        bean.setNetworkCodeName(this.getNetWorkName(bean.getNetworkCode()));
        bean.setCreateTimeShow(Util.getDate((String)FORMAT, (Date)new Date(bean.getCreateTime())));
        bean.setLastUpdateTimeShow(Util.getDate((String)FORMAT, (Date)new Date(bean.getLastUpdateTime())));
        bean.setStatusName(this.getStatusName(bean.getStatus()));
        String resouceType = "";
        if ("1".equals(bean.getResourceType())) {
            resouceType = "\u4e00\u7c7b\u8d44\u6e90";
        } else if ("2".equals(bean.getResourceType())) {
            resouceType = "\u4e8c\u7c7b\u8d44\u6e90";
        } else if ("3".equals(bean.getResourceType())) {
            resouceType = "\u4e09\u7c7b\u8d44\u6e90";
        }
        bean.setResourceTypeName(resouceType);
        return bean;
    }

    @Override
    @Transactional
    public void update(ResourceBean queryBean) {
        Resource entity = this.resourceDao.queryById(queryBean.getResourceId());
        if (entity == null) {
            return;
        }
        entity.setStatus(queryBean.getStatus());
        entity.setLastUpdateTime(System.currentTimeMillis());
        this.resourceDao.update(entity);
    }

    @Override
    @Transactional
    public void setPublishScope(ResourceBean bean) {
        ResourceScopeBean scopeBean;
        String[] arr;
        ResourceScopeBean queryBean = new ResourceScopeBean();
        Resource resource = this.resourceDao.queryById(bean.getResourceId());
        queryBean.setResourceId(bean.getResourceId());
        List<SbmaResourceScope> oldScopes = this.resourceScopeDao.queryList(queryBean);
        ArrayList<ResourceScopeBean> newScopes = new ArrayList<ResourceScopeBean>();
        long currentTime = System.currentTimeMillis();
        for (SbmaResourceScope scope : oldScopes) {
            scope.setStatus(0);
            scope.setLastUpdateTime(currentTime++);
            this.resourceScopeDao.update(scope);
        }
        ResourceScopeBean defaultScopeBean = new ResourceScopeBean();
        defaultScopeBean.setPublishNetworkCode(resource.getNetworkCode());
        defaultScopeBean.setPublishRegionalismCode(resource.getRegionalismCode());
        newScopes.add(defaultScopeBean);
        if (StringUtils.hasText((String)bean.getRegionalismCodes())) {
            arr = bean.getRegionalismCodes().split(",");
            scopeBean = null;
            for (String regionalismCode : arr) {
                if (regionalismCode.equals(resource.getRegionalismCode())) continue;
                scopeBean = new ResourceScopeBean();
                scopeBean.setPublishNetworkCode(resource.getNetworkCode());
                scopeBean.setPublishRegionalismCode(regionalismCode);
                newScopes.add(scopeBean);
            }
        }
        if (StringUtils.hasText((String)bean.getNetworkCodes())) {
            arr = bean.getNetworkCodes().split(",");
            scopeBean = null;
            for (String networkCode : arr) {
                if (networkCode.equals(resource.getNetworkCode())) continue;
                scopeBean = new ResourceScopeBean();
                scopeBean.setPublishNetworkCode(networkCode);
                scopeBean.setPublishRegionalismCode(resource.getRegionalismCode());
                newScopes.add(scopeBean);
            }
        }
        if (!CollectionUtils.isEmpty(newScopes)) {
            SbmaResourceScope newEntity = null;
            for (ResourceScopeBean newScope : newScopes) {
                newEntity = new SbmaResourceScope();
                BeanUtils.copyProperties((Object)newScope, (Object)newEntity);
                newEntity.setLastUpdateTime(currentTime++);
                newEntity.setStatus(1);
                newEntity.setCreateTime(currentTime++);
                newEntity.setResourceId(bean.getResourceId());
                this.resourceScopeDao.add(newEntity);
            }
        }
        resource.setLastUpdateTime(currentTime++);
        this.resourceDao.update(resource);
    }

    private String getOpenFlagName(Integer openFlag) {
        if (openFlag == null) {
            return "";
        }
        int openFlagI = openFlag;
        return openFlagI == 0 ? "\u4e0d\u516c\u5f00" : (openFlagI == 1 ? "\u516c\u5f00" : "");
    }

    private String getNetWorkName(String netWorkCode) {
        if ("1".equals(netWorkCode)) {
            return "\u4e00\u7c7b";
        }
        if ("2".equals(netWorkCode)) {
            return "\u4e8c\u7c7b";
        }
        if ("3".equals(netWorkCode)) {
            return "\u4e09\u7c7b";
        }
        return "";
    }

    private String getStatusName(Integer status) {
        if (status == null) {
            return "";
        }
        int s = status;
        if (s == 4) {
            return "\u5df2\u4e0a\u67b6";
        }
        if (s == 5) {
            return "\u5df2\u4e0b\u67b6";
        }
        return "";
    }

    @Override
    @Transactional
    public void addResource(Resource resource) {
        resource.setLastUpdateTime(System.currentTimeMillis());
        this.resourceDao.add(resource);
    }
}

