/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resregist.control;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.entity.ResourceApply;
import pams.function.sbma.resregist.service.RegistService;

@Controller
@Scope(value="session")
public class RegistResController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistResController.class);
    @Autowired
    private RegistService registService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    @RequestMapping(value={"/sbma/ResRegistController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u5e94\u7528\u8d44\u6e90\u6388\u6743\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/ResRegistController/query.do"})
    public void queryList(String resName, Integer status, Integer page, Integer rows, HttpServletResponse response) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Page pages = new Page(page.intValue(), rows.intValue());
            List<ResourceApplyBean> list = this.registService.getList(resName, status, pages);
            map.put("rows", list);
            map.put("total", pages.getTotal());
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @RequestMapping(value={"/sbma/ResRegistController/toDetail.do"})
    public String toDetail(String id, String type, ModelMap modelMap) {
        ResourceApplyBean bean;
        if (!StringUtils.isEmpty((String)id) && (bean = this.registService.getResApply(id)) != null) {
            type = bean.getType() + "";
            modelMap.addAttribute("resourceId", (Object)bean.getResourceId());
        }
        modelMap.addAttribute("id", (Object)id);
        modelMap.addAttribute("type", (Object)type);
        String typeName = "";
        if (type.equals("3")) {
            typeName = "\u8d44\u6e90\u5e93\u8d44\u6e90-\u5de8\u9f99";
        }
        if (type.equals("4")) {
            typeName = "\u8d44\u6e90\u5e93\u8d44\u6e90-\u4ea4\u7ba1\u516d\u5408\u4e00";
        }
        modelMap.addAttribute("typeName", (Object)typeName);
        modelMap.addAttribute("regionalism", (Object)this.systemConfigPbService.getValueByCode("regionalismCode"));
        return "sbma/resregist/default/resApplyInfo";
    }

    @RequestMapping(value={"/sbma/ResRegistController/getDetailSync.do"})
    public void getDetailSync(String id, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)id)) {
            ResourceApplyBean bean = this.registService.getResApply(id);
            if (bean != null) {
                map.put("flag", "1");
                map.put("res", bean);
            }
        } else {
            map.put("flag", "0");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/sbma/ResRegistController/add_edit.do"})
    public void doAddOrEdit(@RequestBody String param, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            ResourceApply apply = (ResourceApply)JSON.parseObject((String)param, ResourceApply.class);
            if (apply == null) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            apply.setCreatorId(this.operator.getPerson().getId());
            apply.setCreatorName(this.operator.getPerson().getName());
            apply.setOwnerDepCode(this.operator.getPerson().getDepartment().getCode());
            apply.setOwnerIdentifier(this.operator.getPerson().getIdentifier());
            if (StringUtils.isEmpty((String)apply.getResourceApplyId())) {
                this.registService.addResApply(apply);
            } else {
                this.registService.updateResApply(apply);
            }
            map.put("flag", "1");
        }
        catch (Exception e) {
            LOGGER.error("\u8d44\u6e90\u6ce8\u518c\u5931\u8d25:{}", (Object)e.getMessage());
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/sbma/ResRegistController/doCheckDsName.do"})
    public void doCheckDsName(String dsName, String resId, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "1");
        try {
            boolean flag;
            if (!Strings.isEmpty((String)dsName) && (flag = this.registService.checkDsName(dsName, resId))) {
                map.put("flag", "0");
                throw new Exception("\u6570\u636e\u6e90\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
        }
        catch (Exception e) {
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

