/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resregist.service.impl;

import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.entity.ResourceApply;
import pams.function.sbma.resapply.service.ResourceApplyService;
import pams.function.sbma.resmanager.service.ResourceService;
import pams.function.sbma.resregist.service.RegistService;

@Service
public class RegistServiceImpl
implements RegistService {
    @Autowired
    private ResourceApplyService resourceApplyService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    @Override
    public List<ResourceApplyBean> getList(String resourceName, Integer status, Page page) {
        ResourceApplyBean bean = new ResourceApplyBean();
        bean.setName(resourceName);
        bean.setStatus(status);
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(3);
        types.add(4);
        bean.setTypes(types);
        List<ResourceApplyBean> list = this.resourceApplyService.queryList(bean, page);
        return list;
    }

    @Override
    public ResourceApplyBean getResApply(String id) {
        ResourceApplyBean bean = this.resourceApplyService.queryById(id);
        return bean;
    }

    @Override
    @Transactional
    public boolean addResApply(ResourceApply resourceApply) throws Exception {
        try {
            String regionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
            resourceApply.setRegionalismCode(regionalismCode);
            resourceApply.setStatus(2);
            resourceApply.setResourceApplyId(UUIDUtil.random());
            resourceApply.setCreateTime(System.currentTimeMillis());
            this.setDefaultFiled(resourceApply);
            this.resourceApplyService.addResourceApply(resourceApply);
            return true;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    @Transactional
    public boolean updateResApply(ResourceApply resourceApply) throws Exception {
        try {
            String orgResId = resourceApply.getResourceId();
            String regionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
            resourceApply.setRegionalismCode(regionalismCode);
            resourceApply.setStatus(2);
            resourceApply.setResourceId(orgResId);
            resourceApply.setCreateTime(System.currentTimeMillis());
            this.setDefaultFiled(resourceApply);
            resourceApply.setResourceApplyId(UUIDUtil.random());
            this.resourceApplyService.addResourceApply(resourceApply);
            return true;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public boolean checkDsName(String dsName, String resId) {
        return this.resourceApplyService.isDsNameIsExists(dsName, resId);
    }

    private void setDefaultFiled(ResourceApply resourceApply) {
        resourceApply.setResouceServiceType("20");
        resourceApply.setResourceOperatorType("1");
        resourceApply.setResourceInterfaceType("11");
        resourceApply.setResourceInterfaceAddress("http://127.0.0.1:8340/drs/v1/appQuery.do");
        resourceApply.setPowerType("32");
    }
}

