/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.datasource.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.common.bean.RestfulResult;
import pams.function.sbma.datasource.bean.DatasourceBean;
import pams.function.sbma.datasource.service.DatasourceService;

@Controller
@Scope(value="session")
@RequestMapping(value={"/sbma/datasourceController/"})
public class DatasourceController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DatasourceController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private UserManageService userManageService;

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/list.do"})
    public void list(HttpServletResponse response, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = this.datasourceService.queryList(page, rows);
            JSONArray data = jsonObject.getJSONArray("data");
            for (Object object : data) {
                JSONObject o = (JSONObject)object;
                Person person = this.userManageService.queryPersonById(o.getString("userId"));
                if (person == null) continue;
                o.put("creatorName", (Object)person.getName());
            }
            map.put("flag", "1");
            map.put("total", jsonObject.get((Object)"count"));
            map.put("rows", data);
        }
        catch (Exception e) {
            map.put("flag", "0");
            map.put("total", "0");
            map.put("rows", Collections.EMPTY_LIST);
            log.error("\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/toDetail.do"})
    public String toDetail(ModelMap map, String dsId) {
        try {
            String detail = this.datasourceService.queryDetail(dsId);
            RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)detail, (TypeReference)new TypeReference<RestfulResult<DatasourceBean>>(){}, (Feature[])new Feature[0]);
            map.put((Object)"detail", restfulResult.getData());
        }
        catch (Exception e) {
            return "error/error";
        }
        return "sbma/datasource/default/detail";
    }

    @RequestMapping(value={"/toEdit.do"})
    public String toEdit(ModelMap map, String dsId) {
        try {
            String detail = this.datasourceService.queryDetail(dsId);
            RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)detail, (TypeReference)new TypeReference<RestfulResult<DatasourceBean>>(){}, (Feature[])new Feature[0]);
            map.put((Object)"detail", restfulResult.getData());
        }
        catch (Exception e) {
            return "error/error";
        }
        return "sbma/datasource/default/edit";
    }

    @RequestMapping(value={"/toAdd.do"})
    public String toAdd() {
        return "sbma/datasource/default/add";
    }

    @RequestMapping(value={"/addOrEdit.do"})
    public void addOrEdit(HttpServletResponse response, HttpServletRequest request, DatasourceBean datasourceBean) {
        String result;
        try {
            String operatorId = this.getOperator(request).getPerson().getId();
            datasourceBean.setOperatorId(operatorId);
            if (StringUtils.isBlank((CharSequence)datasourceBean.getDsId())) {
                datasourceBean.setUserId(operatorId);
                result = this.datasourceService.addDatasource(datasourceBean);
            } else {
                result = this.datasourceService.editDatasource(datasourceBean);
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6216\u4fee\u6539\u6570\u636e\u6e90\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            result = JSON.toJSONString(RestfulResult.create(null, null, "500", e.getMessage(), null));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/del.do"})
    public void delete(HttpServletResponse response, HttpServletRequest request, String dsId) {
        String result;
        try {
            String operatorId = this.getOperator(request).getPerson().getId();
            result = this.datasourceService.deleteDatasource(dsId, operatorId);
        }
        catch (Exception e) {
            result = JSON.toJSONString(RestfulResult.create(null, null, "500", e.getMessage(), null));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/queryDsList.do"})
    public void queryDsList(HttpServletResponse response, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONArray data = this.datasourceService.queryDsList(type);
            map.put("flag", "1");
            map.put("rows", data);
        }
        catch (Exception e) {
            map.put("total", "0");
            map.put("flag", "0");
            map.put("rows", Collections.EMPTY_LIST);
            log.error("\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

