/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappmanager.control;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.tims.bean.AppNoticeBean;
import com.xdja.pams.tims.service.MsgPushService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.resappapply.entity.AppResourceApply;
import pams.function.sbma.resappapply.service.AppResourceApplyService;
import pams.function.sbma.resappmanager.bean.AppBean;
import pams.function.sbma.resappmanager.bean.PageBean;
import pams.function.sbma.resappmanager.service.SbmaAppManagerService;

@Controller
@Scope(value="session")
public class SbmaAppManagerControler
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(SbmaAppManagerControler.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SbmaAppManagerService appManagerService;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    private MsgPushService msgPushService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    MsgPushService sendAppNotice;
    @Autowired
    private AppResourceApplyService appResourceApplyService;

    @RequestMapping(value={"/sbma/AppResourceManagerController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String fastdfsUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/queryAppList.do"})
    public void queryAppList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, AppBean appBean) {
        int operateResult = 1;
        this.setOperator(request);
        String resultJson = null;
        try {
            appBean.setMdpOperatorUserId(this.person.getId());
            resultJson = this.appManagerService.queryList(appBean, page);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/upAndDownApp.do"})
    public void upAndDownApp(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String showStatus) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.upAndDownApp(appId, showStatus, this.person.getId());
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u7528\u4e0a\u67b6\u4e0b\u67b6\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/recommend.do"})
    public void recommend(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String recommend) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.recommend(appId, recommend, this.person.getId());
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u63a8\u8350\u6216\u53d6\u6d88\u63a8\u8350\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/zjbb.do"})
    public void zjbb(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String label) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.zjbb(appId, label, this.person.getId());
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u63a8\u8350\u6216\u53d6\u6d88\u63a8\u8350\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/queryHistoryList.do"})
    public void queryHistoryList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, String appId) {
        int operateResult = 1;
        this.setOperator(request);
        String resultJson = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            resultJson = this.appManagerService.queryHistoryList(appId, page, personId);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toDetails.do"})
    public String toDetails(String applyId, String appId, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        AppBean appBean = new AppBean();
        String fastdfsUrl = "";
        try {
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
            String personId = this.person != null ? this.person.getId() : null;
            appBean = this.appManagerService.getAppManager(applyId, appId, personId);
            appBean.setApplyId(applyId);
            String localRegionalism = this.systemConfigService.getValueByCode("regionalismCode");
            List<AppResourceApply> list = this.appResourceApplyService.getResourceOfAppByAppInfoFromMdp(appBean.getAppId());
            map.put((Object)"appResource", list);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
        }
        map.put((Object)"appBean", (Object)appBean);
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        if (!Util.varCheckEmp((String)applyId)) {
            return "sbma/resappmanager/defaulte/detailsTmp";
        }
        return "sbma/resappmanager/defaulte/details";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toAudit.do"})
    public String toAudit(String applyId, String resApplyId, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        AppBean appBean = new AppBean();
        String fastdfsUrl = "";
        try {
            String personId = this.person != null ? this.person.getId() : null;
            appBean = this.appManagerService.getAppManager(applyId, null, personId);
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
            appBean.setApplyId(resApplyId);
            String localRegionalism = this.systemConfigService.getValueByCode("regionalismCode");
            List<AppResourceApply> list = this.appResourceApplyService.getResourceOfAppByAppInfoFromMdp(appBean.getAppId());
            map.put((Object)"appResource", list);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
        }
        map.put((Object)"appBean", (Object)appBean);
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return "sbma/resappmanager/defaulte/audit";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toView.do"})
    public String toView(String appId, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        map.put((Object)"appId", (Object)appId);
        return "sbma/resappmanager/defaulte/view";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/appAduit.do"})
    public void appAduit(ModelMap map, HttpServletRequest request, HttpServletResponse response, String auditUserId, String applyId, String auditResult, String approveStatus, String lockVersion) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            pageBean = this.appManagerService.appAduit(this.person.getId(), applyId, auditResult, approveStatus, lockVersion);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/createApp.do"})
    public void createApp(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String applyId, String lockVersion) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.createApp(appId, applyId, personId, lockVersion);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/updateApp.do"})
    public void updateApp(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String applyId, String lockVersion) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.updateApp(appId, applyId, personId, lockVersion);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
                AppBean appBean = this.appManagerService.getAppManager(appId);
                AppNoticeBean appNoticeBean = new AppNoticeBean();
                appNoticeBean.setAppId(appId);
                appNoticeBean.setAppName(appBean.getAppName());
                appNoticeBean.setPackageName(appBean.getAppPackage());
                appNoticeBean.setMsg(sendContent);
                try {
                    this.msgPushService.sendUpdateAppNotice(appNoticeBean);
                }
                catch (Exception e) {
                    log.error("\u5e94\u7528\u53d1\u5e03\u53d1\u9001\u5347\u7ea7\u63a8\u9001\u5931\u8d25\uff01", (Throwable)e);
                }
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/setAppResEnableOrDisable.do"})
    public void setAppResEnableOrDisable(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String able) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.setAppResEnableOrDisable(appId, able, personId);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/setAppVersionRollback.do"})
    public void setAppVersionRollback(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String able) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.setAppVersionRollback(appId, personId);
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u7248\u672c\u56de\u9000\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/silentInstall.do"})
    public void silentInstall(HttpServletRequest request, HttpServletResponse response, String appId, String silentInstall) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.silentInstall(appId, silentInstall, this.person.getId());
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u9759\u9ed8\u5b89\u88c5\u8bbe\u7f6e\u51fa\u9519", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/getMdpDictByType.do"})
    public void getDictByType(String type, HttpServletResponse response) {
        String jsonList = "";
        try {
            List<Map<String, Object>> mapList = this.appManagerService.getMdpDictByType(type);
            jsonList = JSON.toJSONString(mapList);
        }
        catch (Exception e) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + type + "\u3011\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)jsonList);
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toSetReleaseScope.do"})
    public String toSetReleaseScope(String appId, ModelMap modelMap) {
        try {
            Object allReleaseScope = this.appManagerService.getAllReleaseScope();
            Object appReleaseScope = this.appManagerService.getAppReleaseScope(appId);
            String divisionCode = this.appManagerService.getDivisionCode();
            modelMap.put((Object)"allReleaseScope", (Object)JSON.toJSONString((Object)allReleaseScope));
            modelMap.put((Object)"divisionCode", (Object)divisionCode);
            modelMap.put((Object)"appReleaseScope", (Object)JSON.toJSONString((Object)appReleaseScope));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "error/error";
        }
        return "sbma/resappmanager/defaulte/releaseScope";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/setReleaseScope.do"})
    public void setReleaseScope(String appId, String area, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            this.appManagerService.setReleaseScope(appId, area);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u53d1\u5e03\u8303\u56f4\u51fa\u9519", (Throwable)e);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toResDetailPage.do"})
    public String toResDetailPage(String appResApplyId, String resourceId, String resourceRegionalismCode, ModelMap map) {
        map.addAttribute("appResApplyId", (Object)appResApplyId);
        map.addAttribute("resourceId", (Object)resourceId);
        map.addAttribute("resourceRegionalismCode", (Object)resourceRegionalismCode);
        return "sbma/resappmanager/defaulte/resInfo";
    }
}

