/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import pams.function.sbma.common.bean.RestfulQuery;
import pams.function.sbma.common.bean.RestfulResult;
import pams.function.sbma.resappmanager.bean.RoamAppAuthInfo;
import pams.function.sbma.resappmanager.bean.RoamAppAuthInfoNew;
import pams.function.sbma.resappmanager.bean.RoamAppInfo;
import pams.function.sbma.resappmanager.bean.RoamAppInfoResult;
import pams.function.sbma.resappmanager.bean.RoamAppSearchBean;
import pams.function.sbma.resappmanager.bean.RoamPersonInfo;
import pams.function.sbma.resappmanager.service.SbmaOtherPlaceAppAuthService;

@Service
public class SbmaOtherPlaceAppAuthServiceImpl
implements SbmaOtherPlaceAppAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SbmaOtherPlaceAppAuthServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private UserManageService userManageService;

    @Override
    public List<RoamAppInfo> listOtherPlaceAppInfo(RoamAppSearchBean searchBean, Page page) {
        try {
            String mdpUrl = this.systemConfigPbService.getValueByCode("sodUrl");
            String url = this.spellUrl(mdpUrl, "app/queryRoamAppList");
            RestfulQuery<RoamAppSearchBean> restfulQuery = new RestfulQuery<RoamAppSearchBean>();
            String messageId = UUIDUtil.random();
            restfulQuery.setMessageId(messageId);
            restfulQuery.setVersion("1.0");
            restfulQuery.setParameter(searchBean);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String result = httpRequestUtil.httpPostJson(url, JSON.toJSONString(restfulQuery));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sod\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            }
            RestfulResult<RoamAppInfoResult> restfulResult = RestfulResult.getInstance(result, RoamAppInfoResult.class);
            Assert.notNull(restfulResult, (String)"\u4ecesod\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u7ed3\u679c\u4e3a\u7a7a");
            Assert.state((boolean)messageId.equals(restfulResult.getMessageId()), (String)"sod\u8fd4\u56de\u7684\u8bf7\u6c42ID\u5f02\u5e38");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("sod\u8fd4\u56de\u72b6\u6001\u5f02\u5e38:%s", restfulResult.getMessage()));
            RoamAppInfoResult roamAppInfoResult = restfulResult.getData();
            Assert.notNull((Object)roamAppInfoResult, (String)"mdp\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            page.setTotal(roamAppInfoResult.getCount().intValue());
            return roamAppInfoResult.getData();
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void changePower(RoamAppInfo roamAppInfo, List<String> personIds) throws Exception {
        try {
            Assert.notNull((Object)roamAppInfo, (String)"\u53c2\u6570\u5f02\u5e38");
            String localRegionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
            RoamAppAuthInfo rpi = new RoamAppAuthInfo();
            rpi.setAppId(roamAppInfo.getAppId());
            rpi.setAppName(roamAppInfo.getAppName());
            rpi.setAppNetworkCode(roamAppInfo.getAppNetworkCode());
            rpi.setAppPackageName(roamAppInfo.getAppPackage());
            rpi.setAppRegionalismCode(roamAppInfo.getAppRegionalismCode());
            rpi.setPersonRegionalismCode(localRegionalismCode);
            ArrayList<RoamPersonInfo> personInfos = new ArrayList<RoamPersonInfo>();
            if (!personIds.isEmpty()) {
                for (String personId : personIds) {
                    if (Strings.isEmpty((String)personId)) continue;
                    Person person = this.userManageService.getPersonByPersonId(personId);
                    RoamPersonInfo rp = new RoamPersonInfo();
                    Department department = person.getDepartment();
                    rp.setDepCode(department.getCode());
                    rp.setDepId(department.getId());
                    rp.setDepName(department.getName());
                    rp.setMobile(((Mobile)person.getMobiledList().get(0)).getMobile());
                    rp.setPersonCode(person.getCode());
                    rp.setPersonId(person.getId());
                    rp.setPersonIdentifier(person.getIdentifier());
                    rp.setPersonName(person.getName());
                    rp.setPersonType(person.getPersonType());
                    rp.setPolice(person.getPolice());
                    rp.setPosition(person.getPosition());
                    rp.setSex(person.getSex());
                    rp.setType("1");
                    personInfos.add(rp);
                }
            }
            rpi.setPersonInfos(personInfos);
            RestfulQuery<RoamAppAuthInfo> restfulQuery = new RestfulQuery<RoamAppAuthInfo>();
            String messageId = UUIDUtil.random();
            restfulQuery.setMessageId(messageId);
            restfulQuery.setVersion("1.0");
            restfulQuery.setParameter(rpi);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
            String url = this.spellUrl(uasUrl, "/roamAppAuth/applyPower.do");
            String result = httpRequestUtil.postJson(url, JSON.toJSONString(restfulQuery));
            LOGGER.debug("uas\u8fd4\u56de\u6743\u9650\u53d8\u66f4\u7ed3\u679c:{}", (Object)result);
            RestfulResult<Map> restfulResult = RestfulResult.getInstance(result, Map.class);
            Assert.notNull(restfulResult, (String)"uas\u53d8\u66f4\u6743\u9650\u7ed3\u679c\u4e3a\u7a7a");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("\u53bbuas\u53d8\u66f4\u6743\u9650\u7ed3\u679c\u5f02\u5e38: %s", restfulResult.getMessage()));
            Map map = restfulResult.getData();
            String code = (String)map.get("code");
            String message = (String)map.get("message");
            Assert.state((boolean)"1".equals(code), (String)String.format("uas\u53d8\u66f4\u6743\u9650\u5931\u8d25: %s", message));
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void changePower(RoamAppInfo roamAppInfo, List<String> addPersonIds, List<String> cancelPersonIds) throws Exception {
        ArrayList<RoamAppAuthInfoNew> param = new ArrayList<RoamAppAuthInfoNew>();
        String local = this.systemConfigPbService.getValueByCode("regionalismCode");
        try {
            RoamAppAuthInfoNew r;
            for (String ap : addPersonIds) {
                if (Strings.isEmpty((String)ap)) continue;
                r = new RoamAppAuthInfoNew();
                r.setAppId(roamAppInfo.getAppId());
                r.setAppRegionalismCode(roamAppInfo.getAppRegionalismCode());
                r.setPersonId(ap);
                r.setPersonRegionalismCode(local);
                r.setType("1");
                param.add(r);
            }
            for (String cp : cancelPersonIds) {
                if (Strings.isEmpty((String)cp)) continue;
                r = new RoamAppAuthInfoNew();
                r.setAppId(roamAppInfo.getAppId());
                r.setAppRegionalismCode(roamAppInfo.getAppRegionalismCode());
                r.setPersonId(cp);
                r.setPersonRegionalismCode(local);
                r.setType("3");
                param.add(r);
            }
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            HashMap<String, String> headers = new HashMap<String, String>();
            String messageId = UUIDUtil.random();
            headers.put("messageId", messageId);
            headers.put("appCredential", "1234");
            String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
            String url = this.spellUrl(uasUrl, "/v1/authUserAppController/applyUserPower.do");
            Map result = httpRequestUtil.httpPostJsonRet(url, JSON.toJSONString(param), headers);
            String resultCode = (String)result.get("code");
            String message = (String)result.get("message");
            if (!"0".equals(resultCode)) {
                throw new Exception("\u64cd\u4f5c\u5931\u8d25" + message);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public List<Person> getAuthedPerson(RoamAppInfo appInfo) throws Exception {
        String localRegionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
        String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
        String url = this.spellUrl(uasUrl, "/roamAppAuth/getAuthedPerson.do");
        try {
            RoamAppAuthInfo roamAppAuthInfo = new RoamAppAuthInfo();
            roamAppAuthInfo.setPersonRegionalismCode(localRegionalismCode);
            roamAppAuthInfo.setAppRegionalismCode(appInfo.getAppRegionalismCode());
            roamAppAuthInfo.setAppNetworkCode(appInfo.getAppNetworkCode());
            roamAppAuthInfo.setAppId(appInfo.getAppId());
            RestfulQuery<RoamAppAuthInfo> query = new RestfulQuery<RoamAppAuthInfo>();
            String messageId = UUIDUtil.random();
            query.setMessageId(messageId);
            query.setVersion("1.0");
            query.setParameter(roamAppAuthInfo);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String result = httpRequestUtil.postJson(url, JSON.toJSONString(query));
            LOGGER.debug("uas\u8fd4\u56de\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u7ed3\u679c:{}", (Object)result);
            RestfulResult<List<String>> restfulResult = RestfulResult.getInstanceListDate(result, String.class);
            Assert.notNull(restfulResult, (String)"uas\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u4e3a\u7a7a");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("\u53bbuas\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u5f02\u5e38: %s", restfulResult.getMessage()));
            List<String> list = restfulResult.getData();
            ArrayList<Person> personList = new ArrayList<Person>();
            if (list != null && !list.isEmpty()) {
                for (String id : list) {
                    Person p = this.userManageService.getPersonByPersonId(id);
                    if (p == null) continue;
                    Person pp = new Person();
                    pp.setId(p.getId());
                    pp.setCode(p.getCode());
                    pp.setName(p.getName());
                    personList.add(pp);
                }
            }
            return personList;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String spellUrl(String part1, String part2) {
        StringBuilder sb = new StringBuilder();
        if (part1.endsWith("/")) {
            sb.append(part1.substring(0, part1.lastIndexOf("/")));
        } else {
            sb.append(part1);
        }
        if (part2.startsWith("/")) {
            sb.append(part2);
        } else {
            sb.append("/").append(part2);
        }
        return sb.toString();
    }
}

