/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resregist.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.sbma.common.bean.RestfulQuery;
import pams.function.sbma.common.bean.RestfulResult;
import pams.function.sbma.resregist.bean.ResourceTmpBean;
import pams.function.sbma.resregist.service.RegistService;

@Service
public class RegistServiceImpl
implements RegistService {
    private static final Logger logger = LoggerFactory.getLogger(RegistServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    private String mdpUrl;

    @Override
    public JSONObject getList(String resourceName, Integer status, Integer pageNo, Integer pageSize) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/queryResourceApplyList.do";
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("pageNo", pageNo);
        parameter.put("pageSize", pageSize);
        if (status != null) {
            parameter.put("status", status);
        }
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            parameter.put("resourceName", resourceName);
        }
        parameter.put("type", new Integer[]{3, 4});
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u5217\u8868\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return RestfulResult.checkCodeAndGetData(result);
    }

    @Override
    public JSONObject getResApply(String id) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/getResourceApplyById.do";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("resourceApplyId", id);
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u8d44\u6e90\u5e93\u8d44\u6e90\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return RestfulResult.checkCodeAndGetData(result);
    }

    @Override
    public String addResApply(ResourceTmpBean resourceApply) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/saveResourceApply.do";
        RestfulQuery<ResourceTmpBean> restfulQuery = RestfulQuery.getRestfulQuery(resourceApply);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u65b0\u589e\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u65b0\u589e\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u65b0\u589e\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u65b0\u589e\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u8d44\u6e90\u5e93\u8d44\u6e90\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return result;
    }

    @Override
    public String updateResApply(ResourceTmpBean resourceApply) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/updateResourceApply.do";
        RestfulQuery<ResourceTmpBean> restfulQuery = RestfulQuery.getRestfulQuery(resourceApply);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u4fee\u6539\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u4fee\u6539\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u4fee\u6539\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u4fee\u6539\u8d44\u6e90\u5e93\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u4fee\u6539\u8d44\u6e90\u5e93\u8d44\u6e90\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return result;
    }

    private void setMdpUrl() {
        this.mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        if (StringUtils.isBlank((CharSequence)this.mdpUrl)) {
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6emdp\u5730\u5740");
        }
    }

    private ResponseWrap postRequest(String url, RestfulQuery restfulQuery) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)restfulQuery));
        }
        return HttpUtils.post((String)url).setConnectTimeout(500).addJson((Object)restfulQuery).execute();
    }
}

