/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.dao.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.scms.entity.Device;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.mdp.app.bean.App;
import pams.function.smcs.dao.SmcsDao;
import pams.function.smcs.entity.AppStatus;

@Repository
public class SmcsDaoImpl
implements SmcsDao {
    @Autowired
    BaseDao baseDao;

    @Override
    public List<Device> queryAscDeviceList(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* from ( select d.*  ");
        sb.append(" from t_device d, t_person p where d.person_id = p.id ");
        sb.append(" and p.flag= ? ");
        sb.append(" and p.dep_id in ( " + BimsUtil.getChildDepsSql((String)"8888888888") + ")");
        sb.append(" and d.n_last_update_time > ? ");
        sb.append(" order by d.n_last_update_time ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{"0", lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Device.class);
    }

    @Override
    public List<Department> queryAscDepartmentList(Long lastUpdateTime, Integer batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* from ( select d.*  ");
        sb.append(" from t_department d  ");
        sb.append(" where d.n_last_update_time > ? order by d.n_last_update_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Department.class);
    }

    @Override
    public List<Person> queryAscPersonList(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* ");
        sb.append(" from ( select p.*  from t_person p ");
        sb.append(" where p.n_last_update_time > ? order by p.n_last_update_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Person.class);
    }

    @Override
    public List<App> queryAscAppList(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* from ( select p.app_id \"appId\", p.modify_time \"modifyTime\"");
        sb.append(" from t_app p ");
        sb.append(" where (p.modify_time - to_date('1970-01-01 08:00:00','yyyy-mm-dd hh24:mi:ss'))* 24 * 60 * 60 * 1000 > ? order by p.modify_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, App.class);
    }

    @Override
    public List<AppStatus> queryAppStatus() {
        String sql = "select ROUND(nvl(a.score, 0)) as score,nvl(a.review,0) as pointsRank,b.app_id,b.download_count as DOWNNUM,b.downRank,row_number() OVER ( ORDER BY nvl(a.review,0) desc) as appraiseNum  from ( select app_id  ,avg(ar_score) as score ,count(app_id) as review from T_MDP_APP_REVIEW a  where STATISTICS_FLAG=1 and if_enable=1  group by app_id ) a,  (select app_id,download_count,row_number() OVER ( ORDER BY download_count desc) as downRank  from T_APP_COUNT t order by download_count desc) b where a.app_id(+)=b.app_id";
        return this.baseDao.getListBySQL(sql, null, AppStatus.class);
    }
}

