/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.dao.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.Person4Smcs;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.scms.entity.Device;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.mdp.app.bean.App;
import pams.function.smcs.dao.SmcsDao;
import pams.function.smcs.entity.AppStatus;

@Repository
public class SmcsDaoImpl
implements SmcsDao {
    @Autowired
    BaseDao baseDao;

    @Override
    public List<Device> queryAscDeviceList(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* from ( select d.*  ");
        sb.append(" from t_device d, t_person p where d.person_id = p.id ");
        sb.append(" and p.flag= ? ");
        sb.append(" and p.dep_id in ( " + BimsUtil.getChildDepsSql((String)"8888888888") + ")");
        sb.append(" and d.n_last_update_time > ? ");
        sb.append(" order by d.n_last_update_time ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{"0", lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Device.class);
    }

    @Override
    public List<Department> queryAscDepartmentList(Long lastUpdateTime, Integer batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* from ( select d.*  ");
        sb.append(" from t_department d  ");
        sb.append(" where d.n_last_update_time > ? order by d.n_last_update_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Department.class);
    }

    @Override
    public List<Person> queryAscPersonList(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* ");
        sb.append(" from ( select p.* , img.IMG as \"personImage\"  from t_person p ");
        sb.append(" left join T_PERSON_IMG img on p.id = img.PERSON_ID and img.STATE = 1 ");
        sb.append(" where p.n_last_update_time > ? order by p.n_last_update_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Person.class);
    }

    @Override
    public List<Person4Smcs> queryAscPersonList4Smcs(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* ");
        sb.append(" from ( select ");
        sb.append(" p.ID as \"id\", ");
        sb.append(" p.LOGIN_TIME as \"clientLoginTime\", ");
        sb.append(" p.CODE as \"code\", ");
        sb.append(" p.COMM_TYPE as \"commType\", ");
        sb.append(" p.CREATE_DATE as \"createDate\", ");
        sb.append(" p.CREATOR_ID as \"creatorId\", ");
        sb.append(" p.DEP_ID as \"depId\", ");
        sb.append(" p.FLAG as \"flag\", ");
        sb.append(" p.GRADE as \"grade\", ");
        sb.append(" p.IDENTIFIER as \"identifier\", ");
        sb.append(" p.LAST_CHANGE_PW_DATE as \"lastChangePwDate\", ");
        sb.append(" p.LAST_ERRLOGIN_DATE as \"lastErrorLoginTime\", ");
        sb.append(" p.LAST_UPDATEPASS_TIME as \"lastUpdatePassTime\", ");
        sb.append(" p.LEADER_LEVEL as \"leaderLevel\", ");
        sb.append(" p.CLIENT_LOCK_STATE as \"lockState\", ");
        sb.append(" p.ERROR_TIMES as \"loginErrorTimes\", ");
        sb.append(" p.MOBILE as \"mobile\", ");
        sb.append(" p.NAME as \"name\", ");
        sb.append(" p.NOTE as \"note\", ");
        sb.append(" p.OFFICE_PHONE as \"officePhone\", ");
        sb.append(" p.ORDER_FIELD as \"orderField\", ");
        sb.append(" p.PASSWORD as \"password\", ");
        sb.append(" p.STATE as \"personState\", ");
        sb.append(" p.POLICE as \"police\", ");
        sb.append(" p.POSITION as \"position\", ");
        sb.append(" p.POSITION_INPUT as \"positionInput\", ");
        sb.append(" p.SMOBILE as \"sMobile\", ");
        sb.append(" p.SEX as \"sex\", ");
        sb.append(" p.THEME as \"theme\", ");
        sb.append(" p.N_LAST_UPDATE_TIME as \"timestamp\", ");
        sb.append(" p.DEP_CODE as \"depCode\", ");
        sb.append(" p.NAME_BRIEF_SPELL as \"nameBriefSpell\", ");
        sb.append(" p.PERSON_TYPE as \"personType\", ");
        sb.append(" p.PC_ID as \"pcId\", ");
        sb.append(" p.DISPLAY_STATE as \"displayState\", ");
        sb.append(" p.SHORTCUT_MENU as \"shortcutMenu\", ");
        sb.append(" p.MOBILE_PERSONAL as \"mobilePersonal\", ");
        sb.append(" p.MOBILE_MULTIMEDIA_MESSAGE as \"mobileMultimediaMessage\", ");
        sb.append(" p.JX_FLAG as \"jxFlag\", ");
        sb.append(" p.JOB as \"jobIds\", ");
        sb.append("img.IMG as \"personImage\"  from t_person p ");
        sb.append(" left join T_PERSON_IMG img on p.id = img.PERSON_ID and img.STATE = 1 ");
        sb.append(" where p.n_last_update_time > ? order by p.n_last_update_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, Person4Smcs.class);
    }

    @Override
    public List<App> queryAscAppList(long lastUpdateTime, int batchSize) {
        StringBuilder sb = new StringBuilder(" select t.* from ( select p.app_id \"appId\", p.modify_time \"modifyTime\"");
        sb.append(" from t_app p ");
        sb.append(" where (p.modify_time - to_date('1970-01-01 08:00:00','yyyy-mm-dd hh24:mi:ss'))* 24 * 60 * 60 * 1000 > ? order by p.modify_time asc ) t");
        sb.append(" where rownum <= ? ");
        Object[] params = new Object[]{lastUpdateTime, batchSize};
        return this.baseDao.getListBySQL(sb.toString(), params, App.class);
    }

    @Override
    public List<AppStatus> queryAppStatus() {
        String sql = "select ROUND(nvl(a.score, 0)) as score,nvl(a.review,0) as pointsRank,b.app_id,b.download_count as DOWNNUM,b.downRank,row_number() OVER ( ORDER BY nvl(a.review,0) desc) as appraiseNum  from ( select app_id  ,avg(ar_score) as score ,count(app_id) as review from T_MDP_APP_REVIEW a  where STATISTICS_FLAG=1 and if_enable=1  group by app_id ) a,  (select app_id,download_count,row_number() OVER ( ORDER BY download_count desc) as downRank  from T_APP_COUNT t order by download_count desc) b where a.app_id(+)=b.app_id";
        return this.baseDao.getListBySQL(sql, null, AppStatus.class);
    }
}

