/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.job;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.QuartzUtil;
import java.util.Calendar;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.smcs.service.AppPersonLimitsService;

public class AppPersonLimitsReportJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppPersonLimitsReportJob.class);
    private AppPersonLimitsService appPersonLimitsService;
    private SystemConfig systemConfig = SystemConfig.getInstance();
    private static int todayExecuteTimes = 0;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (this.appPersonLimitsService == null) {
            this.appPersonLimitsService = (AppPersonLimitsService)BeanUtils.getBean(AppPersonLimitsService.class);
        }
        try {
            this.appPersonLimitsService.reportToSmcs();
            todayExecuteTimes = 0;
        }
        catch (Exception e) {
            LOGGER.error("\u4eba\u5458\u5e94\u7528\u6743\u9650\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7 \u5931\u8d25", (Throwable)e);
            LOGGER.info("\u521b\u5efa\u4e34\u65f6\u4efb\u52a1\uff0c\u518d\u6b21\u4e0a\u62a5\u6570\u636e", (Throwable)e);
            int retryTime = this.systemConfig.getInt("smcs.app.person.limits.report.retry.times", 3);
            if (retryTime - ++todayExecuteTimes > 0) {
                this.createTmpJob();
            }
            todayExecuteTimes = 0;
        }
    }

    private Date getRetryTime() {
        int interval = this.systemConfig.getInt("smcs.app.person.limits.report.retry.interval.hour", 2);
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, interval);
        return calendar.getTime();
    }

    private void createTmpJob() {
        try {
            QuartzUtil.startSimpleJob((String)"sapl-retry", (Date)this.getRetryTime(), AppPersonLimitsReportJob.class, (int)1, (int)3, (int)0, null);
        }
        catch (SchedulerException e) {
            LOGGER.error("\u521b\u5efa\u91cd\u65b0\u4e0a\u62a5\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

