/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import pams.function.smcs.bean.AppPersonLimits;
import pams.function.smcs.dao.AppPersonLimitsDao;
import pams.function.smcs.service.AppPersonLimitsService;

@Service
public class AppPersonLimitsServiceImpl
implements AppPersonLimitsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppPersonLimitsServiceImpl.class);
    @Autowired
    private AppPersonLimitsDao appPersonLimitsDao;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    private static final String SMCS_RESULT_CODE_SUCCESS = "1";

    @Override
    public void reportToSmcs() throws Exception {
        List<AppPersonLimits> appPersonLimits;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u4e0a\u62a5\u5e94\u7528\u6743\u9650\u5230\u96c6\u4e2d\u7ba1\u63a7");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String smcsUrl = this.systemConfigPbService.getValueByCode("SMCS_URL");
        String repotUrl = smcsUrl + "/api/public/app/permissions/report";
        String preReportUrl = smcsUrl + "/api/public/report/preReport";
        String preReportResult = httpRequestUtil.get(preReportUrl, "businessTable=t_app_permissions");
        this.resolveResultJson(preReportResult);
        int pageNo = 1;
        int pageSize = 200;
        int total = 0;
        while ((appPersonLimits = this.appPersonLimitsDao.pageListAppPersonLimits(new Page(pageNo, pageSize))) != null) {
            if (!appPersonLimits.isEmpty()) {
                total += appPersonLimits.size();
                String json = JSONArray.toJSONString(appPersonLimits);
                String resultJson = httpRequestUtil.httpPostJson(repotUrl, json);
                this.resolveResultJson(resultJson);
            }
            if (appPersonLimits.size() < pageSize) break;
            ++pageNo;
        }
        String commitUrl = smcsUrl + "/api/public/report/commitReport";
        String resultJson = httpRequestUtil.get(commitUrl, "businessTable=t_app_permissions&recordCount=" + total);
        this.resolveResultJson(resultJson);
        stopWatch.stop();
        String s = stopWatch.prettyPrint();
        LOGGER.info(s);
    }

    private void resolveResultJson(String resultJson) throws Exception {
        JSONObject result = JSON.parseObject((String)resultJson);
        String code = result.getString("code");
        if (!SMCS_RESULT_CODE_SUCCESS.equals(code)) {
            LOGGER.error("\u8bf7\u6c42\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a{}", (Object)result);
            throw new Exception(result.getString("message"));
        }
    }
}

