/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.syn.entity.MDPAndPolice;
import com.xdja.pams.syn.service.PersonMDPService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.app.bean.App;
import pams.function.mdp.app.bean.AppBean;
import pams.function.mdp.app.service.AppManagerService;
import pams.function.smcs.bean.ReportInfo;
import pams.function.smcs.bean.SmcsTypeEnum;
import pams.function.smcs.dao.SmcsDao;
import pams.function.smcs.service.SmcsReportService;
import pams.function.smcs.service.impl.SmcsAbstactReportServiceImpl;
import pams.function.smcs.service.impl.SmcsAppStatusReportServiceImpl;

@Service
public class SmcsAppReportServiceImpl
extends SmcsAbstactReportServiceImpl<App>
implements SmcsReportService {
    @Autowired
    private SmcsDao smcsDao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AppManagerService appManagerService;
    @Autowired
    private PersonMDPService personMDPService;
    private static final Logger log = LoggerFactory.getLogger(SmcsAppStatusReportServiceImpl.class);

    @Override
    protected List<App> queryAscReportList(Long lastUpdateTime, Integer batchSize) {
        return this.smcsDao.queryAscAppList(lastUpdateTime, batchSize);
    }

    @Override
    protected long getObjectUpdateTime(App app) {
        return app.getModifyTime().getTime();
    }

    @Override
    protected boolean isDeleteObject(App app) {
        return false;
    }

    @Override
    protected List<Map<String, String>> formatReportList(List<App> reportList) throws Exception {
        ArrayList<AppBean> appBeanList = new ArrayList<AppBean>();
        for (App app : reportList) {
            AppBean appBean = this.appManagerService.getAppManager(app.getAppId());
            appBeanList.add(appBean);
        }
        String fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        for (AppBean appBean : appBeanList) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String logoFileName = appBean.getAppLogoFileName();
            String logoFileExt = logoFileName.substring(logoFileName.lastIndexOf(".") + 1);
            byte[] logoByte = this.getLogo(fastdfsUrl + appBean.getAppLogoFileName());
            if (logoByte != null && logoByte.length > 0) {
                Base64Encrypt base64Encrypt = new Base64Encrypt();
                String imgBase64 = base64Encrypt.getBase64FromBytes(logoByte);
                paramMap.put("logo", "data:image/" + logoFileExt + ";base64," + imgBase64);
            }
            paramMap.put("appId", appBean.getAppId());
            paramMap.put("appPackage", appBean.getAppPackage());
            paramMap.put("name", appBean.getAppName());
            String userId = appBean.getCreateUserId();
            MDPAndPolice creater = this.personMDPService.getMDPAndPoliceById(userId);
            if (creater != null) {
                if (StringUtils.isNotBlank((CharSequence)creater.getDepName())) {
                    paramMap.put("org", creater.getDepName());
                }
                if (StringUtils.isNotBlank((CharSequence)creater.getVendorsName())) {
                    paramMap.put("developer", creater.getVendorsName());
                }
            }
            paramMap.put("type", appBean.getAppTypeName());
            paramMap.put("version", appBean.getAppVersion());
            paramMap.put("description", appBean.getAppDescription());
            paramMap.put("state", appBean.getAppStatus());
            paramMap.put("fileUrl", appBean.getAppFileName());
            paramMap.put("fileSize", appBean.getAppFileSizeMB());
            paramMap.put("updateTime", Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)appBean.getModifyTime()));
            paramMap.put("createTime", Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)appBean.getCreateTime()));
            paramMap.put("time", Util.getDate((String)"yyyy-MM-dd HH:mm:ss"));
            paramList.add(paramMap);
        }
        return paramList;
    }

    @Override
    protected Map<String, String> formatDeleteReportMap(App reportApp) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getLogo(String logoUrl) {
        URL url = null;
        try {
            url = new URL(logoUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bos.close();
        }
        catch (IOException e) {
            log.error("getLogo\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25");
            }
        }
        return bos.toByteArray();
    }

    @Override
    public void doReport() throws Exception {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSwitchCode("SMCS_APP_STATUS_SWITCH");
        reportInfo.setSaveUrl("/api/public/app/save");
        reportInfo.setTimestampCode("SMCS_APP_TIMESTAMP");
        reportInfo.setSmcsTypeEnum(SmcsTypeEnum.smcsApp);
        log.debug("\u589e\u91cf\u5411\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5e94\u7528\u7ebf\u7a0b\u5f00\u59cb\u3002reportInfo:{}", (Object)JSON.toJSONString((Object)reportInfo));
        super.doReport(reportInfo);
    }
}

