/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.CommonCodeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.smcs.bean.ReportInfo;
import pams.function.smcs.bean.SmcsTypeEnum;
import pams.function.smcs.dao.SmcsDao;
import pams.function.smcs.service.impl.SmcsAbstactReportServiceImpl;

@Service
public class SmcsPersonReportServiceImpl
extends SmcsAbstactReportServiceImpl<Person> {
    @Autowired
    private SmcsDao smcsDao;
    @Autowired
    private CommonCodeService commonCodeService;
    private static final Logger log = LoggerFactory.getLogger(SmcsPersonReportServiceImpl.class);

    @Override
    public List<Person> queryAscReportList(Long lastUpdateTime, Integer batchSize) {
        return this.smcsDao.queryAscPersonList(lastUpdateTime, batchSize);
    }

    @Override
    protected long getObjectUpdateTime(Person person) {
        return person.getTimestamp();
    }

    @Override
    protected boolean isDeleteObject(Person person) {
        return "1".equals(person.getFlag());
    }

    @Override
    protected List<Map<String, String>> formatReportList(List<Person> reportList) throws Exception {
        ArrayList<Map<String, String>> formatList = new ArrayList<Map<String, String>>();
        for (Person person : reportList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("orgId", person.getDepId());
            map.put("userId", person.getId());
            map.put("userName", person.getName());
            map.put("sex", "1".equals(person.getSex()) ? "1" : "2");
            map.put("officePhone", person.getOfficePhone());
            map.put("mobile", person.getMobile());
            map.put("type", person.getPersonType());
            map.put("cardNo", person.getIdentifier());
            map.put("policeId", person.getCode());
            String police = person.getPolice();
            map.put("classification", this.commonCodeService.getCodeNameByCode(police, "2012"));
            Date date = new Date(person.getTimestamp());
            map.put("updateTime", Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)date));
            map.put("createTime", Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)date));
            map.put("time", Util.getDate((String)"yyyy-MM-dd HH:mm:ss"));
            formatList.add(map);
        }
        return formatList;
    }

    @Override
    protected Map<String, String> formatDeleteReportMap(Person reportPerson) {
        if (reportPerson == null || StringUtils.isBlank((CharSequence)reportPerson.getId())) {
            return null;
        }
        HashMap<String, String> deleteReportMap = new HashMap<String, String>();
        deleteReportMap.put("userId", new String(reportPerson.getId()));
        return deleteReportMap;
    }

    @Override
    public void doReport() throws Exception {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSwitchCode("SMCS_DEPARTMENT_PERSON_SWITCH");
        reportInfo.setTimestampCode("SMCS_PERSON_TIMESTAMP");
        reportInfo.setSaveUrl("/api/public/person/save");
        reportInfo.setDeleteUrl("/api/public/person/delete");
        reportInfo.setSmcsTypeEnum(SmcsTypeEnum.smcsPerson);
        log.debug("\u589e\u91cf\u5411\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u4eba\u5458\u7ebf\u7a0b\u5f00\u59cb\u3002reportInfo:{}", (Object)JSON.toJSONString((Object)reportInfo));
        super.doReport(reportInfo);
    }
}

