/*
 * Decompiled with CFR 0.152.
 */
package pams.function.uniteauth.bean;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.uniteauth.bean.KeyBean;

public class PfxSSLCert {
    private static final Logger logger = LoggerFactory.getLogger(PfxSSLCert.class);
    private static Map<String, PrivateKey> privateKeys = new HashMap<String, PrivateKey>();
    private static Map<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();
    private static Map<String, X509Certificate> certMaps = new HashMap<String, X509Certificate>();
    protected static String keyStoreType = "pkcs12";

    private byte[] intToNetByteArray(int integer, int length) {
        byte[] b = new byte[length];
        if (length <= 0) {
            return null;
        }
        for (int j = 0; j < length; ++j) {
            b[length - 1 - j] = (byte)(integer >> j * 8);
        }
        return b;
    }

    public static void createFromP12(String path, String pwd) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            KeyStore ks = KeyStore.getInstance(keyStoreType, "BC");
            ks.load(new FileInputStream(path), pwd.toCharArray());
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String keyAlias = aliases.nextElement();
                PrivateKey privateKey = (PrivateKey)ks.getKey(keyAlias, pwd.toCharArray());
                X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
                PublicKey publicKey = cert.getPublicKey();
                String sn = PfxSSLCert.getSn(cert);
                System.out.println("\u83b7\u53d6\u5230\u7684\u522b\u540d\u662f\uff1a" + keyAlias);
                System.out.println("\u83b7\u53d6\u5230\u7684SN\u662f\uff1a" + sn);
                System.out.println("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u662f\uff1a" + keyAlias);
                System.out.println("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u662f\uff1a" + keyAlias);
                certMaps.put(keyAlias, cert);
                privateKeys.put(sn, privateKey);
                publicKeys.put(sn, publicKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bfb\u53d6system\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private static String getSn(X509Certificate cert) {
        String sn = cert.getSerialNumber().toString(16);
        while (sn.length() < 16) {
            sn = "0" + sn;
        }
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyBean getSNAndKeyByChipId(String chipID, String filePath, String keyStorePassword) {
        KeyBean result = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        String keyStorePath = filePath + chipID + ".p12";
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            ks.load(new FileInputStream(keyStorePath), keyStorePassword.toCharArray());
            Enumeration<String> aliases = ks.aliases();
            Certificate[] certs = null;
            while (aliases.hasMoreElements()) {
                String keyAlias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
                if (!keyAlias.equals(chipID + "sm2sign")) continue;
                ECPrivateKey privateKey = (ECPrivateKey)ks.getKey(keyAlias, keyStorePassword.toCharArray());
                String sn = PfxSSLCert.getSn(cert);
                certs = ks.getCertificateChain(keyAlias);
                ECPublicKey ecPublicKey = (ECPublicKey)certs[0].getPublicKey();
                result = new KeyBean(sn, ecPublicKey, privateKey);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790p12\u6587\u4ef6\u5931\u8d25 {}", (Object)keyStorePath, (Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyBean getSNAndKeyByAlias(String keyAlias, String filePath, String keyStorePassword) {
        KeyBean result = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            ks.load(new FileInputStream(filePath), keyStorePassword.toCharArray());
            Certificate[] certs = null;
            X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
            ECPrivateKey privateKey = (ECPrivateKey)ks.getKey(keyAlias, keyStorePassword.toCharArray());
            String sn = PfxSSLCert.getSn(cert);
            certs = ks.getCertificateChain(keyAlias);
            ECPublicKey ecPublicKey = (ECPublicKey)certs[0].getPublicKey();
            result = new KeyBean(sn, ecPublicKey, privateKey);
            result.setCert(cert);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790p12\u6587\u4ef6\u5931\u8d25 {}", (Object)(filePath + ":alias:" + keyAlias), (Object)e);
        }
        return result;
    }
}

