/*
 * Decompiled with CFR 0.152.
 */
package pams.function.uniteauth.controller;

import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.uniteauth.bean.UaAppInfoBean;
import pams.function.uniteauth.entity.UaAppInfo;
import pams.function.uniteauth.service.UaAppManagerService;

@Controller
@Scope(value="session")
public class AppManagerController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppManagerController.class);
    @Autowired
    private UaAppManagerService uaAppManagerService;

    @RequestMapping(value={"/uniteAuth/appManager/index.do"})
    public String toIndex(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u5e94\u7528\u8d44\u6e90\u6388\u6743\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/uniteAuth/appManager/query.do"})
    public void queryList(String appName, Integer page, Integer rows, HttpServletResponse response) {
        try {
            if (page == null) {
                page = 1;
            }
            if (rows == null) {
                rows = 10;
            }
            Map<String, Object> map = this.uaAppManagerService.pageAppInfo(appName, page, rows);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/uniteAuth/appManager/appInfo.do"})
    public String getAppInfo(String id, ModelMap modelMap) {
        try {
            UaAppInfoBean bean = null;
            if (!Strings.isEmpty((String)id)) {
                bean = this.uaAppManagerService.getAppInfoById(Long.parseLong(id));
            }
            if (bean == null) {
                bean = new UaAppInfoBean();
                bean.setAppName("\u8fd9\u662f\u4e2a\u5e94\u7528\u540d\u79f0");
                bean.setPackageName("com.xdja.test");
                bean.setCertHashVal("123123123123123123");
                bean.setSuitStyle(2568L);
                bean.setType(1);
                bean.setAppId(UUIDUtil.random());
            }
            modelMap.addAttribute("app", (Object)bean);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return "uniteAuth/appManager/default/appInfo";
    }

    @RequestMapping(value={"/uniteAuth/appManager/addInfo.do"})
    public void addAppInfo(UaAppInfo appInfo, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            this.uaAppManagerService.add(appInfo);
            map.put("flag", "1");
        }
        catch (Exception e) {
            LOGGER.error("\u589e\u52a0\u5e94\u7528\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/uniteAuth/appManager/delete.do"})
    public void deleteApp(String id, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "0");
        try {
            if (Strings.isEmpty((String)id)) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            this.uaAppManagerService.updateStatus(Long.parseLong(id), 3);
            map.put("flag", "1");
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5931\u8d25:{}", (Object)e.getMessage());
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/uniteAuth/appManager/download.do"})
    public void downloadFile(String id, HttpServletResponse response) {
        try {
            int len;
            if (Strings.isEmpty((String)id)) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            UaAppInfoBean bean = this.uaAppManagerService.getAppInfoById(Long.parseLong(id));
            String path = bean.getAuthPath();
            response.setContentType("application/x-zip-compressed");
            response.setHeader("Content-Disposition", "attachment;filename=" + bean.getAppId() + ".zip");
            ServletOutputStream out = response.getOutputStream();
            FileInputStream fin = new FileInputStream(path);
            byte[] temp = new byte[4096];
            while ((len = fin.read(temp)) > 0) {
                out.write(temp, 0, len);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u6388\u6743\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/uniteAuth/appManager/toAll.do"})
    public String toAdd() {
        return "uniteAuth/appManager/default/addInfo";
    }
}

