/*
 * Decompiled with CFR 0.152.
 */
package pams.function.uniteauth.dao.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.util.Strings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import pams.function.uniteauth.bean.UaAppInfoBean;
import pams.function.uniteauth.dao.UaAppManagerDao;
import pams.function.uniteauth.entity.UaAppInfo;

public class UaAppManagerDaoImpl
implements UaAppManagerDao {
    private JdbcTemplate uaJdbcTemplate;

    @Override
    public List<UaAppInfoBean> listAppInfo(final String appName, Page page) {
        StringBuilder from = new StringBuilder(" from t_app_info where n_status != 3 ");
        if (Strings.isNotEmpty((String)appName)) {
            from.append(" and c_name like ?");
        }
        PreparedStatementSetter preparedStatementSetter = new PreparedStatementSetter(){

            public void setValues(PreparedStatement preparedStatement) throws SQLException {
                if (Strings.isNotEmpty((String)appName)) {
                    preparedStatement.setString(1, "%" + appName + "%");
                }
            }
        };
        int count = Strings.isNotEmpty((String)appName) ? this.uaJdbcTemplate.queryForInt("select count(*) " + from.toString(), new Object[]{"%" + appName + "%"}) : this.uaJdbcTemplate.queryForInt("select count(*) " + from.toString());
        if (count <= 0) {
            return new ArrayList<UaAppInfoBean>();
        }
        int pageNo = page.getPage();
        int pageSize = page.getRp();
        from.append(" LIMIT ").append((pageNo - 1) * pageSize).append(", ").append(pageSize);
        List list = (List)this.uaJdbcTemplate.query("select * " + from.toString(), preparedStatementSetter, (ResultSetExtractor)new ResultSetExtractor<List<UaAppInfoBean>>(){

            public List<UaAppInfoBean> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<UaAppInfoBean> list = new ArrayList<UaAppInfoBean>();
                while (rs.next()) {
                    UaAppInfoBean appInfo = new UaAppInfoBean();
                    appInfo.setId(rs.getLong("n_id"));
                    appInfo.setAppId(rs.getString("c_app_id"));
                    appInfo.setAppName(rs.getString("c_name"));
                    appInfo.setPackageName(rs.getString("c_package_name"));
                    appInfo.setPackageSize(rs.getString("c_package_size"));
                    appInfo.setCopyRight(rs.getString("c_copyright"));
                    appInfo.setInternalVersion(rs.getString("c_internal_version"));
                    appInfo.setVersion(rs.getString("c_version"));
                    appInfo.setPackageHashVal(rs.getString("c_package_hashval"));
                    appInfo.setCertHashVal(rs.getString("c_cert_hashval"));
                    appInfo.setAuthPath(rs.getString("c_auth_path"));
                    appInfo.setAuthHashVal(rs.getString("c_auth_hashval"));
                    appInfo.setStatus(rs.getInt("n_status"));
                    appInfo.setSecretKey(rs.getString("c_secretkey"));
                    appInfo.setToken(rs.getString("c_token"));
                    appInfo.setCreateTime(rs.getLong("n_time"));
                    appInfo.setType(rs.getInt("n_type"));
                    appInfo.setAuthTime(rs.getLong("n_audit_time"));
                    appInfo.setAuthId(rs.getInt("n_audit_id"));
                    appInfo.setAppNote(rs.getString("c_app_note"));
                    appInfo.setSuitStyle(rs.getLong("n_suit_style"));
                    appInfo.setAuthFileName(rs.getString("c_auth_name"));
                    list.add(appInfo);
                }
                return list;
            }
        });
        page.setTotal(count);
        return list;
    }

    @Override
    public UaAppInfo getAppInfoById(final Long id) {
        if (id == null) {
            return null;
        }
        String sql = "select * from t_app_info where n_id = ?";
        PreparedStatementSetter preparedStatementSetter = new PreparedStatementSetter(){

            public void setValues(PreparedStatement preparedStatement) throws SQLException {
                preparedStatement.setLong(1, id);
            }
        };
        return (UaAppInfo)this.uaJdbcTemplate.query(sql, preparedStatementSetter, (ResultSetExtractor)new ResultSetExtractor<UaAppInfo>(){

            public UaAppInfo extractData(ResultSet rs) throws SQLException, DataAccessException {
                UaAppInfo appInfo = null;
                while (rs.next()) {
                    appInfo = new UaAppInfo();
                    appInfo.setId(rs.getLong("n_id"));
                    appInfo.setAppId(rs.getString("c_app_id"));
                    appInfo.setAppName(rs.getString("c_name"));
                    appInfo.setPackageName(rs.getString("c_package_name"));
                    appInfo.setPackageSize(rs.getString("c_package_size"));
                    appInfo.setCopyRight(rs.getString("c_copyright"));
                    appInfo.setInternalVersion(rs.getString("c_internal_version"));
                    appInfo.setVersion(rs.getString("c_version"));
                    appInfo.setPackageHashVal(rs.getString("c_package_hashval"));
                    appInfo.setCertHashVal(rs.getString("c_cert_hashval"));
                    appInfo.setAuthPath(rs.getString("c_auth_path"));
                    appInfo.setAuthHashVal(rs.getString("c_auth_hashval"));
                    appInfo.setStatus(rs.getInt("n_status"));
                    appInfo.setSecretKey(rs.getString("c_secretkey"));
                    appInfo.setToken(rs.getString("c_token"));
                    appInfo.setCreateTime(rs.getLong("n_time"));
                    appInfo.setType(rs.getInt("n_type"));
                    appInfo.setAuthTime(rs.getLong("n_audit_time"));
                    appInfo.setAuthId(rs.getInt("n_audit_id"));
                    appInfo.setAppNote(rs.getString("c_app_note"));
                    appInfo.setSuitStyle(rs.getLong("n_suit_style"));
                    appInfo.setAuthFileName(rs.getString("c_auth_name"));
                }
                return appInfo;
            }
        });
    }

    @Override
    public void addAppInfo(final UaAppInfo appInfo) {
        String sql = "insert into t_app_info (c_app_id, c_name, c_package_name, c_cert_hashval, c_auth_path,n_status,c_secretkey,c_token,n_time,n_type,n_audit_time,n_suit_style,c_auth_name) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        int rows = this.uaJdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, appInfo.getAppId());
                ps.setString(2, appInfo.getAppName());
                ps.setString(3, appInfo.getPackageName());
                ps.setString(4, appInfo.getCertHashVal());
                ps.setString(5, appInfo.getAuthPath());
                ps.setInt(6, appInfo.getStatus());
                ps.setString(7, appInfo.getSecretKey());
                ps.setString(8, appInfo.getToken());
                ps.setLong(9, appInfo.getCreateTime());
                ps.setInt(10, appInfo.getType());
                ps.setLong(11, appInfo.getAuthTime());
                ps.setLong(12, appInfo.getSuitStyle());
                ps.setString(13, appInfo.getAuthFileName());
            }
        });
    }

    @Override
    public void updateStatus(final Long id, final Integer status) {
        String sql = "update t_app_info set n_status = ? where n_id = ?";
        int rows = this.uaJdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setInt(1, status);
                ps.setLong(2, id);
            }
        });
    }

    public void setUaJdbcTemplate(JdbcTemplate uaJdbcTemplate) {
        this.uaJdbcTemplate = uaJdbcTemplate;
    }
}

