/*
 * Decompiled with CFR 0.152.
 */
package pams.function.uniteauth.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM3Digest;
import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import pams.function.uniteauth.Util.Base64Utils;
import pams.function.uniteauth.Util.SM2Utils;
import pams.function.uniteauth.Util.ZipUtil;
import pams.function.uniteauth.bean.KeyBean;
import pams.function.uniteauth.bean.PfxSSLCert;
import pams.function.uniteauth.bean.UaAppInfoBean;
import pams.function.uniteauth.dao.UaAppManagerDao;
import pams.function.uniteauth.entity.UaAppInfo;
import pams.function.uniteauth.service.UaAppManagerService;

public class UaAppManagerServiceImpl
implements UaAppManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UaAppManagerServiceImpl.class);
    private UaAppManagerDao uaAppManagerDao;
    private String authFileBasePath;
    private String alias;
    private String password;
    private String keyStoreFile;

    @Override
    public void add(UaAppInfo appInfo) throws Exception {
        try {
            appInfo.setAppId(UUIDUtil.random());
            this.makeAppInfo(appInfo);
            this.makeAuthFile(appInfo);
            this.createZip(appInfo);
            long now = System.currentTimeMillis();
            appInfo.setCreateTime(now);
            appInfo.setAuthTime(now);
            appInfo.setStatus(1);
            this.uaAppManagerDao.addAppInfo(appInfo);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5e94\u7528\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Map<String, Object> pageAppInfo(String appName, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPage(pageNo);
        page.setRp(pageSize);
        List<UaAppInfoBean> list = this.uaAppManagerDao.listAppInfo(appName, page);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        map.put("rows", list);
        return map;
    }

    @Override
    public UaAppInfoBean getAppInfoById(Long id) {
        UaAppInfo uaAppInfo = this.uaAppManagerDao.getAppInfoById(id);
        if (uaAppInfo != null) {
            UaAppInfoBean bean = new UaAppInfoBean();
            BeanUtils.copyProperties((Object)uaAppInfo, (Object)bean);
            return bean;
        }
        return null;
    }

    @Override
    public void updateStatus(Long id, Integer status) {
        if (id == null || status == null) {
            return;
        }
        this.uaAppManagerDao.updateStatus(id, status);
        String appId = "";
    }

    private void makeAppInfo(UaAppInfo appInfo) throws Exception {
        try {
            appInfo.setSecretKey(UaAppManagerServiceImpl.genSecretKey(appInfo.getAppId(), appInfo.getPackageName()));
            URL url = Thread.currentThread().getContextClassLoader().getResource(this.keyStoreFile);
            if (url == null) {
                throw new Exception("\u83b7\u53d6\u79d8\u94a5\u5e93\u6587\u4ef6\u5931\u8d25");
            }
            KeyBean keyBean = PfxSSLCert.getSNAndKeyByAlias(this.alias, url.getPath(), this.password);
            String token = this.genToken(appInfo, keyBean);
            appInfo.setToken(token);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efaappInfo\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new Exception(e);
        }
    }

    private void makeAuthFile(UaAppInfo appInfo) throws Exception {
        PrintWriter pw = null;
        PrintWriter pw2 = null;
        File appInfoDir = null;
        try {
            if (Strings.isEmpty((String)this.authFileBasePath)) {
                throw new Exception("\u7cfb\u7edf\u6ca1\u6709\u914d\u7f6e\u6388\u6743\u6587\u4ef6\u57fa\u672c\u8def\u5f84");
            }
            File base = new File(this.authFileBasePath);
            if (!base.exists() && !base.mkdirs()) {
                throw new Exception("\u521b\u5efa\u6388\u6743\u6587\u4ef6\u57fa\u672c\u76ee\u5f55\u5931\u8d25");
            }
            appInfoDir = new File(base.getPath(), appInfo.getAppId() + File.separator + "authFile");
            if (!appInfoDir.mkdirs()) {
                throw new Exception("\u521b\u5efa\u6388\u6743\u6587\u4ef6\u76ee\u5f55\u5931\u8d25");
            }
            File secretKey = new File(appInfoDir.getPath(), "secretKey.txt");
            pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(secretKey)));
            pw.println(appInfo.getSecretKey());
            pw.flush();
            File tokenPro = new File(appInfoDir.getPath(), "token.pro");
            pw2 = new PrintWriter(new OutputStreamWriter(new FileOutputStream(tokenPro)));
            pw2.println(appInfo.getToken());
            pw2.flush();
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u6388\u6743\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            if (appInfoDir != null) {
                appInfoDir.delete();
            }
            throw new Exception("\u521b\u5efa\u6388\u6743\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (pw2 != null) {
                pw2.close();
            }
        }
    }

    private void createZip(UaAppInfo appInfo) throws Exception {
        try {
            File appInfoDir = new File(this.authFileBasePath, appInfo.getAppId());
            if (!appInfoDir.exists()) {
                throw new Exception("\u6388\u6743\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
            ZipUtil zipUtil = new ZipUtil();
            String authPath = appInfoDir.getPath() + ".zip";
            zipUtil.doZip(appInfoDir.getPath(), appInfoDir.getPath() + ".zip");
            appInfo.setAuthFileName(appInfo.getAppId() + ".zip");
            appInfo.setAuthPath(authPath);
            this.delete(appInfoDir);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u6388\u6743\u538b\u7f29\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new Exception(e.getMessage());
        }
    }

    private String genToken(UaAppInfo info, KeyBean keyBean) throws Exception {
        HashMap<String, Object> tokenData = new HashMap<String, Object>();
        tokenData.put("appId", info.getAppId());
        tokenData.put("packageName", info.getPackageName());
        tokenData.put("suit", info.getSuitStyle());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token_data", tokenData);
        map.put("signature_alg", "sm2WithSm3");
        map.put("signature", this.Sm2WithSm3(info.getAppId() + "||" + info.getPackageName() + "||" + info.getSuitStyle(), keyBean));
        return JSON.toJSONString(map);
    }

    public String Sm2WithSm3(String data, KeyBean keyBean) throws Exception {
        if (Strings.isEmpty((String)data)) {
            return null;
        }
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data.getBytes());
        byte[] sm3Byte = sm3.doFinal();
        byte[] signByte = SM2Utils.sign(keyBean.getPrivateKey(), sm3Byte);
        boolean flag = SM2Utils.verify(keyBean.getPublicKey(), signByte, sm3Byte);
        return Base64Utils.encode(signByte);
    }

    private static String genSecretKey(String appId, String packageName) {
        if (Strings.isEmpty((String)packageName)) {
            packageName = System.currentTimeMillis() + "";
        }
        String source = appId + packageName + ":" + UUID.randomUUID().toString();
        String salt = appId + packageName + ":" + System.nanoTime();
        String str = source + "_" + salt;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes());
            byte[] hash = md5.digest();
            String d = "";
            int usbyte = 0;
            for (int i = 0; i < hash.length; i += 2) {
                usbyte = hash[i] & 0xFF;
                d = usbyte < 16 ? d + "0" + Integer.toHexString(usbyte) : d + Integer.toHexString(usbyte);
                usbyte = hash[i + 1] & 0xFF;
                d = usbyte < 16 ? d + "0" + Integer.toHexString(usbyte) : d + Integer.toHexString(usbyte);
            }
            return d.trim().toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    public boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!(f.isFile() ? !f.delete() : !this.delete(f))) continue;
                return false;
            }
        }
        return file.delete();
    }

    public void setUaAppManagerDao(UaAppManagerDao uaAppManagerDao) {
        this.uaAppManagerDao = uaAppManagerDao;
    }

    public void setAuthFileBasePath(String authFileBasePath) {
        this.authFileBasePath = authFileBasePath;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }
}

