/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.control;

import com.alibaba.fastjson.JSONArray;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.metting.bean.MeetAdminInputBean;
import pams.function.xatl.metting.bean.MeetAdminMemberInputBean;
import pams.function.xatl.metting.bean.QueryMeetAdminBean;
import pams.function.xatl.metting.service.MeetAdminService;
import pams.function.xatl.metting.service.MeetingService;
import pams.function.xatl.metting.util.MeetingUtil;

@Controller
@Scope(value="session")
public class MeetAdminController
extends BaseControler {
    private static final long serialVersionUID = 3537437510250624211L;
    private static final Logger log = LoggerFactory.getLogger(MeetAdminController.class);
    @Autowired
    private MeetAdminService meetAdminService;
    @Autowired
    private MeetingService meetingService;
    @Autowired
    private ResourceBundleMessageSource resourceBundleMessageSource;
    @Autowired
    private UserManageServiceForXatl userManageService;

    @RequestMapping(value={"/meet/MeetAdminController/toAddAdmins.do"})
    public String toAddAdmins(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "attendance/notice/default/addAdmins";
    }

    @RequestMapping(value={"/meet/MeetAdminController/addMeetAdmin.do"})
    public void addMeetAdmin(HttpServletRequest request, HttpServletResponse response, ModelMap map, MeetAdminInputBean meetAdminInputBean) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            String ids = meetAdminInputBean.getPersonIds();
            ids = ids.length() > 1 ? ids.substring(1, ids.length() - 1) : "";
            meetAdminInputBean.setPersonIds(ids);
            meetAdminInputBean.setCreator(this.person.getId());
            this.meetAdminService.addMeetAdmin(meetAdminInputBean);
            returnResult.setData((Object)"200");
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetAdminController/addMeetAdminMember.do"})
    public void addMeetAdminMember(HttpServletRequest request, HttpServletResponse response, ModelMap map, MeetAdminMemberInputBean meetAdminMemberInputBean) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            meetAdminMemberInputBean.setCreator(this.person.getId());
            String ids = meetAdminMemberInputBean.getMemberIds();
            ids = ids.length() > 1 ? ids.substring(1, ids.length() - 1) : "";
            meetAdminMemberInputBean.setMemberIds(ids);
            this.meetAdminService.addMeetAdminMember(meetAdminMemberInputBean);
            returnResult.setData((Object)"200");
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetAdminController/getMeetAdminMemberList.do"})
    public void getMeetAdminMemberList(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryMeetAdminBean queryMeetAdminBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(queryMeetAdminBean.getPage().intValue(), queryMeetAdminBean.getRows().intValue());
            List<Map<String, Object>> listMap = this.meetAdminService.getMemberList(queryMeetAdminBean, page);
            result.put("total", page.getTotal());
            result.put("rows", listMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(result));
    }

    @RequestMapping(value={"/meet/MeetAdminController/getManageList.do"})
    public String getManageList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personId) {
        this.setOperator(request);
        try {
            JSONArray listWork = this.meetingService.getWebDeptAndPerson(personId, "");
            List<Object> personlist = new ArrayList();
            if (null != listWork && listWork.size() > 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < listWork.size(); ++i) {
                    Map entity = (Map)listWork.get(i);
                    list.add(entity.get("id") + "");
                }
                personlist = this.userManageService.queryPersonByPersonIds(list);
            }
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "attendance/notice/default/noticeAuthIndex";
    }

    @RequestMapping(value={"/meet/MeetAdminController/toAddAdmin.do"})
    public String toAddAdmin(HttpServletRequest request, HttpServletResponse response, ModelMap map, String mid) {
        try {
            QueryMeetAdminBean queryMeetAdminBean = new QueryMeetAdminBean();
            Page page = new Page(1, 1000);
            List<Map<String, Object>> listWork = this.meetAdminService.getMemberList(queryMeetAdminBean, page);
            List<Object> personlist = new ArrayList();
            if (null != listWork && listWork.size() > 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < listWork.size(); ++i) {
                    Map<String, Object> entity = listWork.get(i);
                    list.add(entity.get("id") + "");
                }
                personlist = this.userManageService.queryPersonByPersonIds(list);
            }
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "attendance/notice/default/noticeAuthIndex";
    }

    @RequestMapping(value={"/meet/MeetAdminController/deletMeetAdminMember.do"})
    public void deletMeetAdminMember(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ids, String userId) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            this.meetAdminService.deleteMeetAdmin(ids, this.person.getId());
            returnResult.setData((Object)"200");
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetAdminController/getPubPerson.do"})
    public void getPubPerson(HttpServletRequest request, HttpServletResponse response, ModelMap map, String userId) {
        ReturnResult returnResult = new ReturnResult();
        try {
            returnResult.setData((Object)"200");
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }
}

