/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.rpcMethod;

import com.xdja.pams.common.util.Page;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import pams.function.xatl.metting.bean.MeetingBean;
import pams.function.xatl.metting.bean.QueryMeetBean;
import pams.function.xatl.metting.service.MeetingService;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;

@Service
public class GetMeetList
extends LakeMobMethod {
    @Resource
    private MeetingService meetingService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        QueryMeetBean queryMeetBean = new QueryMeetBean();
        int isDraft = request.needInt("isDraft");
        queryMeetBean.setIsDraft(isDraft);
        int page = request.needInt("page");
        queryMeetBean.setPage(page);
        int rows = request.needInt("rows");
        queryMeetBean.setRows(rows);
        queryMeetBean.setUserId(currentUser);
        Page pageParam = new Page(queryMeetBean.getPage().intValue(), queryMeetBean.getRows().intValue());
        List<MeetingBean> list = this.meetingService.getMeetList(queryMeetBean, pageParam);
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        resultData.put("total", pageParam.getTotal());
        resultData.put("dataList", list);
        boolean dataEnd = true;
        if (pageParam.getPage() != 0 && pageParam.getPage() != pageParam.getPageCount() && list.size() != 0) {
            dataEnd = false;
        }
        resultData.put("dataEnd", dataEnd);
        return resultData;
    }
}

