/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import pams.function.xatl.metting.bean.MeetAdminInputBean;
import pams.function.xatl.metting.bean.MeetAdminMemberInputBean;
import pams.function.xatl.metting.bean.QueryMeetAdminBean;
import pams.function.xatl.metting.dao.MeetAdminDao;
import pams.function.xatl.metting.dao.MeetAdminMemberDao;
import pams.function.xatl.metting.entity.MeetingAdmin;
import pams.function.xatl.metting.entity.MeetingAdminMember;
import pams.function.xatl.metting.service.MeetAdminService;

@Service
public class MeetAdminServiceImpl
implements MeetAdminService {
    @Autowired
    private MeetAdminDao meetAdminDao;
    @Autowired
    private MeetAdminMemberDao meetAdminMemberDao;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @Override
    @Transactional(readOnly=false)
    public void addMeetAdmin(MeetAdminInputBean meetAdminInputBean) {
        String newPersonIds = meetAdminInputBean.getPersonIds();
        String creator = meetAdminInputBean.getCreator();
        String oldPersonIds = this.getMemberStr(creator);
        Map<String, List<String>> personIds = MeetAdminServiceImpl.getChangeAccount(newPersonIds, oldPersonIds);
        List<String> addPersonIds = personIds.get("addList");
        List<String> deletePersonIds = personIds.get("deleteList");
        if (addPersonIds != null && addPersonIds.size() > 0) {
            for (String addPersonId : addPersonIds) {
                int personCount = this.meetAdminDao.getAdminMemberCount(addPersonId);
                if (personCount > 0) continue;
                MeetingAdmin meetingAdmin = new MeetingAdmin();
                meetingAdmin.setPersonId(addPersonId);
                meetingAdmin.setCreator(creator);
                meetingAdmin.setCreateTime(new Date());
                this.meetAdminDao.addMeetAdmin(meetingAdmin);
            }
        }
        if (deletePersonIds != null && deletePersonIds.size() > 0) {
            String deltePersonIdStr = StringUtils.collectionToCommaDelimitedString(deletePersonIds);
            this.deleteMeetAdmin(deltePersonIdStr, creator);
        }
    }

    public static Map<String, List<String>> getChangeAccount(String newAccount, String oldAccount) {
        ArrayList commenList = new ArrayList();
        ArrayList addList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        ArrayList<String> accounts = new ArrayList<String>();
        ArrayList<String> oldAccounts = new ArrayList<String>();
        ArrayList oldAccountsTemp = new ArrayList();
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)newAccount)) {
            accounts.addAll(Arrays.asList(newAccount.split(",")));
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)oldAccount)) {
            oldAccounts.addAll(Arrays.asList(oldAccount.split(",")));
            oldAccountsTemp = new ArrayList(oldAccounts);
        }
        oldAccounts.retainAll(accounts);
        commenList = oldAccounts;
        accounts.removeAll(commenList);
        addList = accounts;
        oldAccountsTemp.removeAll(commenList);
        deleteList = oldAccountsTemp;
        HashMap<String, List<String>> getChangeAccount = new HashMap<String, List<String>>();
        getChangeAccount.put("addList", addList);
        getChangeAccount.put("deleteList", deleteList);
        return getChangeAccount;
    }

    @Override
    @Transactional(readOnly=false)
    public void addMeetAdminMember(MeetAdminMemberInputBean meetAdminMemberInputBean) {
        String personId = meetAdminMemberInputBean.getPersonId();
        String memberIds = meetAdminMemberInputBean.getMemberIds();
        String creator = meetAdminMemberInputBean.getCreator();
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)personId) && org.apache.commons.lang.StringUtils.isNotEmpty((String)creator)) {
            this.meetAdminMemberDao.deleteMeetAdminMember(creator, personId);
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)memberIds)) {
                String[] memberIdArray;
                for (String memberId : memberIdArray = memberIds.split(",")) {
                    MeetingAdminMember meetingAdminMember = new MeetingAdminMember();
                    meetingAdminMember.setPersonId(personId);
                    meetingAdminMember.setMemberId(memberId);
                    meetingAdminMember.setCreator(creator);
                    meetingAdminMember.setCreateTime(new Date());
                    this.meetAdminMemberDao.addMeetAdminMember(meetingAdminMember);
                }
            }
        }
    }

    @Override
    public boolean isUserHasPower(String userId) {
        int count = this.meetAdminMemberDao.isUserHasPower(userId);
        return count > 0;
    }

    @Override
    public List<Map<String, Object>> getMemberList(QueryMeetAdminBean queryMeetAdminBean, Page page) {
        List<Map<String, Object>> listMap = this.meetAdminDao.getMemberList(queryMeetAdminBean, page);
        if (listMap != null && listMap.size() > 0) {
            for (Map<String, Object> map : listMap) {
                String personId = (String)map.get("id");
                int controlCount = this.meetAdminMemberDao.getMeetingAdminMemberCount(personId);
                String position = this.commonCodePbService.getCodeNameByCode((String)map.get("position"), "2011");
                map.put("position", position);
                map.put("controlCount", controlCount);
            }
        }
        return listMap;
    }

    private String getMemberStr(String userId) {
        StringBuffer sb = new StringBuffer();
        QueryMeetAdminBean queryMeetAdminBean = new QueryMeetAdminBean();
        queryMeetAdminBean.setUserId(userId);
        List<Map<String, Object>> listMap = this.meetAdminDao.getMemberList(queryMeetAdminBean, null);
        if (listMap != null && listMap.size() > 0) {
            for (Map<String, Object> map : listMap) {
                String personId = (String)map.get("id");
                sb.append(personId).append(",");
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    @Transactional(readOnly=false)
    public void deleteMeetAdmin(String ids, String creator) {
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)ids)) {
            String[] idArray;
            for (String personId : idArray = ids.split(",")) {
                this.meetAdminDao.deleteMeetAdmin(personId, creator);
                this.meetAdminMemberDao.deleteMeetAdminMember(creator, personId);
            }
        }
    }
}

