/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.tims.service.MsgPushService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.metting.bean.MeetingBean;
import pams.function.xatl.metting.bean.MeetingInputBean;
import pams.function.xatl.metting.bean.QueryMeetBean;
import pams.function.xatl.metting.dao.MeetingDao;
import pams.function.xatl.metting.dao.MeetingMemberDao;
import pams.function.xatl.metting.entity.Meeting;
import pams.function.xatl.metting.entity.MeetingDraft;
import pams.function.xatl.metting.entity.MeetingMember;
import pams.function.xatl.metting.service.MeetingService;
import pams.function.xatl.metting.util.BeanUtil;
import pams.function.xatl.metting.util.DateUtils;
import pams.function.xatl.metting.util.MeetingConstants;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class MeetingServiceImpl
implements MeetingService {
    private static final Logger log = LoggerFactory.getLogger(MeetingServiceImpl.class);
    @Autowired
    private MeetingDao meetingDao;
    @Autowired
    private MeetingMemberDao meetingMemberDao;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private MsgPushService msgPushService;
    @Autowired
    private DepManageService deptService;
    @Autowired
    private LakeMobPushService lakeMobPushService;

    @Override
    public List<MeetingBean> getMeetList(QueryMeetBean queryMeetBean, Page page) {
        ArrayList<MeetingBean> meetingBeans;
        block5: {
            block4: {
                meetingBeans = new ArrayList<MeetingBean>();
                int isDraft = queryMeetBean.getIsDraft();
                if (MeetingConstants.ISDRAFT_NO != isDraft) break block4;
                List<MeetingMember> meetingMembers = this.meetingDao.getMeetMemberList(queryMeetBean, page);
                if (meetingMembers == null || meetingMembers.size() <= 0) break block5;
                for (MeetingMember meetingMember : meetingMembers) {
                    String meetId = meetingMember.getMeetId();
                    Meeting meeting = this.meetingDao.getMeetInfo(meetId);
                    MeetingBean meetingBean = this.getMeetingBeanInfo(meetingMember);
                    if (meeting != null) {
                        meetingBean.setTitle(meeting.getTitle());
                        meetingBean.setStartTime(meeting.getStartTime());
                        meetingBean.setEndTime(meeting.getEndTime());
                        meetingBean.setPlace(meeting.getPlace());
                        meetingBean.setContent(meeting.getContent());
                        meetingBean.setIsImportant(meeting.getIsImportant());
                        meetingBean.setCreateTime(meeting.getCreateTime());
                    }
                    meetingBeans.add(meetingBean);
                }
                break block5;
            }
            List<Meeting> meetings = this.meetingDao.getMeetDraftList(queryMeetBean, page);
            if (meetings != null && meetings.size() > 0) {
                for (Meeting meeting : meetings) {
                    MeetingBean meetingBean = this.getMeetingBeanInfo(meeting);
                    meetingBean.setMeetId(meeting.getId());
                    meetingBeans.add(meetingBean);
                }
            }
        }
        return meetingBeans;
    }

    @Override
    public List<MeetingBean> getWebMeetList(QueryMeetBean queryMeetBean, Page page) {
        ArrayList<MeetingBean> meetingBeans = new ArrayList<MeetingBean>();
        if (StringUtils.isEmpty((String)queryMeetBean.getUserId())) {
            return null;
        }
        List<Meeting> meetings = this.meetingDao.getWebMeetList(queryMeetBean, page);
        if (meetings != null && meetings.size() > 0) {
            for (Meeting meeting : meetings) {
                MeetingBean meetingBean = this.getMeetingBeanInfo(meeting);
                meetingBeans.add(meetingBean);
            }
        }
        return meetingBeans;
    }

    @Override
    public List<Map<String, String>> getWebPublish(String userId) {
        List<Map<String, String>> list = this.meetingDao.getWebPublish(userId);
        ArrayList<Map<String, String>> rootList = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "");
        map.put("name", "--\u8bf7\u9009\u62e9--");
        rootList.add(map);
        if (list != null && list.size() > 0) {
            rootList.addAll(list);
        }
        return rootList;
    }

    public MeetingBean getMeetingBeanInfo(Object object) {
        MeetingBean meetingBean = new MeetingBean();
        String meetId = null;
        Integer pubStatus = null;
        String creator = null;
        if (object instanceof MeetingMember) {
            MeetingMember meetingMember = (MeetingMember)object;
            meetId = meetingMember.getMeetId();
            pubStatus = meetingMember.getPubStatus();
            creator = meetingMember.getCreator();
            BeanUtil.copyProperties(meetingMember, meetingBean);
        } else if (object instanceof Meeting) {
            Meeting meeting = (Meeting)object;
            meetId = meeting.getId();
            pubStatus = meeting.getPubStatus();
            creator = meeting.getCreator();
            BeanUtil.copyProperties(meeting, meetingBean);
        } else {
            MeetingDraft meetingDraft = (MeetingDraft)object;
            meetId = meetingDraft.getId();
            pubStatus = meetingDraft.getPubStatus();
            creator = meetingDraft.getCreator();
            BeanUtil.copyProperties(meetingDraft, meetingBean);
        }
        Map<String, List<Map<String, Object>>> meetMember = this.getMeetMember(meetId, pubStatus);
        meetingBean.setReadNum(meetMember.get("readMember").size());
        meetingBean.setUnReadNum(meetMember.get("unReadMember").size());
        meetingBean.setMeetMember(meetMember);
        Person person = this.personDao.queryPersonById(creator);
        if (person != null) {
            meetingBean.setCreatorName(person.getName());
        }
        return meetingBean;
    }

    public Map<String, List<Map<String, Object>>> getMeetMember(String meetId, Integer pubStatus) {
        HashMap<String, List<Map<String, Object>>> meetMember = new HashMap<String, List<Map<String, Object>>>();
        List<Object> readMember = new ArrayList();
        List<Object> unReadMember = new ArrayList();
        if (MeetingConstants.PUBSTATUS_SUCCESS == pubStatus) {
            readMember = this.meetingMemberDao.getMeetMember(meetId, MeetingConstants.READ_MEETING, pubStatus);
            unReadMember = this.meetingMemberDao.getMeetMember(meetId, MeetingConstants.UNREAD_MEETING, pubStatus);
        } else {
            unReadMember = this.meetingMemberDao.getMeetMember(meetId, MeetingConstants.UNREAD_MEETING, pubStatus);
        }
        meetMember.put("readMember", readMember);
        meetMember.put("unReadMember", unReadMember);
        return meetMember;
    }

    @Override
    @Transactional(readOnly=false)
    public void addMeet(MeetingInputBean meetingInputBean) {
        if (meetingInputBean != null) {
            String meetId = meetingInputBean.getId();
            String creator = meetingInputBean.getCreator();
            String members = meetingInputBean.getMembers();
            int pubStatus = meetingInputBean.getPubStatus();
            String startTimeStr = meetingInputBean.getStartTimeStr();
            String endTimeStr = meetingInputBean.getEndTimeStr();
            meetingInputBean.setStartTime(DateUtils.parseDate(startTimeStr));
            meetingInputBean.setEndTime(DateUtils.parseDate(endTimeStr));
            Meeting meeting = new Meeting();
            if (StringUtils.isNotEmpty((String)meetId)) {
                meeting = this.meetingDao.getMeetInfo(meetId);
                int isImportant = meetingInputBean.getIsImportant();
                BeanUtil.copyProperties(meetingInputBean, meeting);
                if (MeetingConstants.PUBSTATUS_SUCCESS == pubStatus) {
                    meeting.setIsDraft(MeetingConstants.ISDRAFT_NO);
                    meeting.setPubStatus(MeetingConstants.PUBSTATUS_SUCCESS);
                    meeting.setCreateTime(new Date());
                } else {
                    meeting.setIsDraft(MeetingConstants.ISDRAFT_YES);
                }
                meeting.setIsImportant(isImportant);
                this.meetingDao.updateMeet(meeting);
            } else {
                BeanUtil.copyProperties(meetingInputBean, meeting);
                if (MeetingConstants.PUBSTATUS_DRAFT.intValue() == meetingInputBean.getPubStatus()) {
                    meeting.setIsDraft(MeetingConstants.ISDRAFT_YES);
                }
                meeting.setIsDelete(MeetingConstants.ISDELETE_NO);
                meetId = this.meetingDao.addMeet(meeting);
            }
            if (StringUtils.isNotEmpty((String)members)) {
                this.editMeetMember(meetId, members, creator, pubStatus);
            }
        }
    }

    public void editMeetMember(String meetId, String members, String creator, int pubStatus) {
        if (StringUtils.isNotEmpty((String)members) && StringUtils.isNotEmpty((String)meetId) && StringUtils.isNotEmpty((String)creator)) {
            this.meetingMemberDao.deleteMeetingMember(meetId, creator);
            String[] memberArray = members.split(",");
            HashSet<String> memberIds = new HashSet<String>(Arrays.asList(memberArray));
            memberIds.add(creator);
            for (String memberId : memberIds) {
                MeetingMember meetingMember = new MeetingMember();
                meetingMember.setMeetId(meetId);
                meetingMember.setMember(memberId);
                meetingMember.setCreator(creator);
                meetingMember.setPubStatus(pubStatus);
                this.meetingMemberDao.addMeetingMember(meetingMember);
            }
            if (MeetingConstants.PUBSTATUS_SUCCESS == pubStatus) {
                this.sendMessage(memberIds, this.meetingDao.getMeetInfo(meetId), creator);
            }
        }
    }

    public void sendMessage(Set<String> memberIds, Meeting meeting, String creator) {
        try {
            Date endTime;
            StringBuffer toIds = new StringBuffer();
            if (memberIds != null && memberIds.size() > 0) {
                for (String memberId : memberIds) {
                    if (memberId.equals(creator)) continue;
                    toIds.append(memberId).append(",");
                }
            }
            if (StringUtils.isEmpty((String)toIds.toString())) {
                return;
            }
            if (toIds.length() > 0) {
                toIds.deleteCharAt(toIds.length() - 1);
            }
            Calendar calendar = Calendar.getInstance();
            ObjectNode content = QuickJson.newObjectNode().put("id", meeting.getId()).put("title", meeting.getTitle()).put("startTime", System.currentTimeMillis()).put("endTime", System.currentTimeMillis()).put("place", meeting.getPlace()).put("isImportant", meeting.getIsImportant());
            Date startTime = meeting.getStartTime();
            if (startTime != null) {
                calendar.setTime(startTime);
                content.put("startTime", calendar.getTimeInMillis());
            }
            if ((endTime = meeting.getStartTime()) != null) {
                calendar.setTime(endTime);
                content.put("endTime", calendar.getTimeInMillis());
            }
            this.lakeMobPushService.pushMeeting(toIds.toString(), content, meeting.getId());
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MeetingBean getMeetInfo(String id, String userId) {
        MeetingBean meetingBean = null;
        Meeting meeting = this.meetingDao.getMeetInfo(id);
        if (meeting != null) {
            this.meetingMemberDao.updateMemberReadStatus(id, userId);
            meetingBean = this.getMeetingBeanInfo(meeting);
        }
        return meetingBean;
    }

    @Override
    @Transactional(readOnly=false)
    public void deletMeet(String userId, String ids) {
        if (StringUtils.isNotEmpty((String)userId) && StringUtils.isNotEmpty((String)ids)) {
            String[] idArray;
            for (String id : idArray = ids.split(",")) {
                Meeting meeting = this.meetingDao.getMeetInfo(id);
                if (meeting == null || !meeting.getCreator().equals(userId) || MeetingConstants.ISDRAFT_YES.intValue() != meeting.getIsDraft()) continue;
                meeting.setIsDelete(MeetingConstants.ISDELETE_YES);
                this.meetingDao.updateMeet(meeting);
                if (MeetingConstants.PUBSTATUS_DRAFT.intValue() != meeting.getPubStatus()) continue;
                this.meetingDao.deleteMeet(meeting);
                this.meetingMemberDao.deleteMeetingMember(id, userId);
            }
        }
    }

    @Override
    public List<Map<String, Object>> getDeptAndPerson(String userId, String deptId) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty((String)deptId)) {
            List<Map<String, String>> rootDept = this.meetingDao.getRootDept();
            if (rootDept != null && rootDept.size() > 0) {
                Map<String, String> rootMap = rootDept.get(0);
                deptId = rootMap.get("id");
                System.out.println(deptId);
                HashMap<String, Object> item = new HashMap<String, Object>();
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("code", rootMap.get("code"));
                item.put("id", rootMap.get("id"));
                item.put("text", rootMap.get("name"));
                item.put("state", "closed");
                item.put("attributes", attr);
                List<Map<String, String>> userList = this.meetingDao.getControlUser(userId, deptId);
                items.add(item);
            }
        } else {
            Department dep2 = this.deptService.queryDepById(deptId);
            for (Department depNode : dep2.getChildDeps()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("code", depNode.getCode());
                item.put("id", depNode.getId());
                item.put("text", depNode.getName());
                item.put("state", "closed");
                item.put("attributes", attr);
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public JSONArray getAllDeptAndPerson(String userId, int getMember, String meetId) {
        List<Map<String, String>> rootDept = this.meetingDao.getRootDept();
        List<Map<String, String>> allDept = this.meetingDao.getAllDept();
        JSONArray dept = this.buildDeptTree(rootDept, allDept, userId);
        return this.BuildDepteAndPersonTree(dept, userId, getMember, meetId);
    }

    @Override
    public JSONArray getAllDeptAndPersonForMobile(String userId, String meetId) {
        JSONArray result = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        List<Map<String, String>> rootDept = this.meetingDao.getRootDept();
        List<Map<String, String>> allDept = this.meetingDao.getAllDept();
        JSONArray jsonArray = this.buildDeptAndPersonTreeMobile(rootDept, allDept, userId, meetId);
        jsonObject.put("childDeptList", (Object)jsonArray);
        result.add((Object)jsonObject);
        return result;
    }

    public JSONArray BuildDepteAndPersonTree(JSONArray paramArray, String userId, int getMember, String meetId) {
        JSONArray result = new JSONArray();
        if (paramArray != null && paramArray.size() > 0) {
            for (int i = 0; i < paramArray.size(); ++i) {
                JSONObject jsonObject = paramArray.getJSONObject(i);
                String deptId = jsonObject.getString("id");
                List<Object> userList = new ArrayList();
                if (MeetingConstants.GETMEMBER_NO == getMember) {
                    userList = this.meetingDao.getAdminUser(userId, deptId);
                } else if (MeetingConstants.GETMEMBER_YES == getMember) {
                    userList = StringUtils.isNotEmpty((String)meetId) ? this.meetingDao.getAdminMemberUserToCheck(userId, meetId, deptId) : this.meetingDao.getAdminMemberUser(userId, deptId);
                }
                if (userList != null && userList.size() > 0) {
                    for (Map map : userList) {
                        BigDecimal checked = (BigDecimal)map.get("checked");
                        if (checked.intValue() == 0) {
                            map.put("checked", false);
                        } else {
                            map.put("checked", true);
                        }
                        map.put("type", "person");
                    }
                }
                JSONArray resultChildren = new JSONArray();
                if (jsonObject.containsKey((Object)"children")) {
                    resultChildren = jsonObject.getJSONArray("children");
                    resultChildren = this.BuildDepteAndPersonTree(resultChildren, userId, getMember, meetId);
                    if (userList.size() > 0) {
                        resultChildren.addAll(userList);
                    }
                    jsonObject.put("children", (Object)resultChildren);
                } else if (userList != null && userList.size() > 0) {
                    jsonObject.put("state", (Object)"open");
                    resultChildren.addAll(userList);
                    jsonObject.put("children", (Object)resultChildren);
                }
                result.add((Object)jsonObject);
            }
        }
        return result;
    }

    public JSONArray buildDeptTree(List<Map<String, String>> upperDepts, List<Map<String, String>> allDepts, String userId) {
        JSONArray jSONArray = new JSONArray();
        if (upperDepts != null && upperDepts.size() > 0) {
            for (Map<String, String> map : upperDepts) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)map.get("id"));
                jsonObject.put("code", (Object)map.get("code"));
                jsonObject.put("text", (Object)map.get("name"));
                jsonObject.put("checked", (Object)false);
                jsonObject.put("type", (Object)"dept");
                ArrayList<Map<String, String>> childDepts = new ArrayList<Map<String, String>>();
                for (Map<String, String> dept : allDepts) {
                    if (dept.get("parentId") == null || !dept.get("parentId").equals(map.get("id"))) continue;
                    childDepts.add(dept);
                }
                if (childDepts != null && childDepts.size() > 0) {
                    jsonObject.put("state", (Object)"open");
                    jsonObject.put("children", (Object)this.buildDeptTree(childDepts, allDepts, userId));
                }
                jSONArray.add((Object)jsonObject);
            }
        }
        return jSONArray;
    }

    @Override
    public JSONArray getWebDeptAndPerson(String userId, String meetId) {
        JSONArray result = new JSONArray();
        List<Object> persons = new ArrayList();
        persons = StringUtils.isNotEmpty((String)meetId) ? this.meetingDao.getAdminMemberUserToCheck(userId, meetId, "") : this.meetingDao.getAdminMemberUser(userId, "");
        if (persons != null && persons.size() > 0) {
            result.addAll(persons);
        }
        return result;
    }

    public JSONArray buildDeptAndPersonTreeMobile(List<Map<String, String>> upperDepts, List<Map<String, String>> allDepts, String userId, String meetId) {
        JSONArray jSONArray = new JSONArray();
        if (upperDepts != null && upperDepts.size() > 0) {
            for (Map<String, String> map : upperDepts) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)map.get("id"));
                jsonObject.put("code", (Object)map.get("code"));
                jsonObject.put("text", (Object)map.get("name"));
                jsonObject.put("checked", (Object)0);
                ArrayList<Map<String, String>> childDepts = new ArrayList<Map<String, String>>();
                for (Map<String, String> dept : allDepts) {
                    if (dept.get("parentId") == null || !dept.get("parentId").equals(map.get("id"))) continue;
                    childDepts.add(dept);
                }
                if (childDepts != null && childDepts.size() > 0) {
                    jsonObject.put("childDeptList", (Object)this.buildDeptAndPersonTreeMobile(childDepts, allDepts, userId, meetId));
                }
                List<Object> userList = new ArrayList();
                userList = StringUtils.isNotEmpty((String)meetId) ? this.meetingDao.getAdminMemberUserToCheck(userId, meetId, map.get("id")) : this.meetingDao.getAdminMemberUser(userId, map.get("id"));
                if (userList != null && userList.size() > 0) {
                    jsonObject.put("userList", userList);
                }
                jSONArray.add((Object)jsonObject);
            }
        }
        return jSONArray;
    }

    public JSONArray buildDeptTreeOrial(List<Map<String, String>> upperDepts, List<Map<String, String>> allDepts, String userId, boolean getAll) {
        JSONArray jSONArray = new JSONArray();
        if (upperDepts != null && upperDepts.size() > 0) {
            for (Map<String, String> map : upperDepts) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)map.get("id"));
                jsonObject.put("code", (Object)map.get("code"));
                jsonObject.put("name", (Object)map.get("name"));
                jsonObject.put("parentId", (Object)map.get("parentId"));
                ArrayList<Map<String, String>> childDepts = new ArrayList<Map<String, String>>();
                for (Map<String, String> dept : allDepts) {
                    if (dept.get("parentId") == null || !dept.get("parentId").equals(map.get("id"))) continue;
                    childDepts.add(dept);
                }
                if (childDepts != null && childDepts.size() > 0) {
                    jsonObject.put("childDeptList", (Object)this.buildDeptTree(childDepts, allDepts, userId));
                }
                List<Map<String, String>> userList = null;
                userList = getAll ? this.meetingDao.getAllUser(map.get("id")) : this.meetingDao.getUser(userId, map.get("id"));
                jsonObject.put("userList", userList);
                jSONArray.add((Object)jsonObject);
            }
        }
        return jSONArray;
    }

    @Override
    @Transactional(readOnly=false)
    public void publishMeeting(String id, String userId) {
        Meeting meeting = this.meetingDao.getMeetInfo(id);
        if (meeting != null) {
            int pubStatus = meeting.getPubStatus();
            if (MeetingConstants.PUBSTATUS_DRAFT == pubStatus) {
                if (!meeting.getCreator().equals(userId)) {
                    return;
                }
                meeting.setPubStatus(MeetingConstants.PUBSTATUS_SUCCESS);
                meeting.setIsDraft(MeetingConstants.ISDRAFT_NO);
                meeting.setCreateTime(new Date());
                this.meetingDao.updateMeet(meeting);
            }
        }
    }
}

