/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.entity.AnnouncementEntity;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.service.AnnouncementService;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.util.FreeworkDateEditor;
import pams.function.xatl.ruyihu.util.MyAssert;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
public class AnnouncementController {
    private Logger LOGGER = LoggerFactory.getLogger(AnnouncementController.class);
    @Resource
    private AnnouncementService announcementService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private AttachmentService attachmentService;

    @InitBinder
    public void initBinder(WebDataBinder binder, WebRequest request) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)FreeworkDateEditor.INSTANCE);
    }

    @RequestMapping(value={"ruyihu/announcementController/announcementAddPage.do"})
    public String announcementAddPage() {
        return "ruyihu/announcement/default/announcementAdd";
    }

    @RequestMapping(value={"ruyihu/announcementController/announcementListPage.do"})
    public String announcementListPage() {
        return "ruyihu/announcement/default/announcementList";
    }

    @ModelAttribute
    public AnnouncementEntity get(@RequestParam(required=false, value="announcementId") String announcementId) {
        if (StringUtils.hasText((String)announcementId)) {
            AnnouncementEntity one = this.announcementService.getAnnouncementById(announcementId);
            MyAssert.notNull(one, "\u516c\u544aid\u4e0d\u5b58\u5728");
            return one;
        }
        return new AnnouncementEntity();
    }

    @RequestMapping(value={"ruyihu/announcementController/list.do"})
    public void list(AnnouncementEntity condition, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, HttpServletResponse response) {
        this.LOGGER.info("\u8c03\u7528 list");
        Page pageParam = new Page(page, rows);
        List<AnnouncementEntity> datas = this.announcementService.getAnnouncementList(condition, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(datas)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (AnnouncementEntity one : datas) {
                ObjectNode put = QuickJson.newObjectNode().put("id", one.getId()).put("title", one.getTitle()).put("department", one.getDepartment()).put("content", one.getContent()).put("publishTime", DateFormatUtils.format((Date)one.getPublishTime(), (String)"yyyy/MM/dd"));
                List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(one.getId(), "anno");
                ArrayNode attachmentListNode = JsonNodeFactory.instance.arrayNode();
                for (AttachmentEntity att : attachments) {
                    attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", att.getAttachmentId()).put("size", att.getAttachmentSize()).put("name", att.getAttachmentName()).put("url", this.fastDFSClientService.getRealDownloadUrl(att.getAttachmentUrl())));
                }
                put.put("attachmentList", (JsonNode)attachmentListNode);
                rowsNode.add((JsonNode)put);
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/announcementController/deleteOne.do"})
    public void deleteOne(AnnouncementEntity one, HttpServletResponse response) {
        this.LOGGER.info("\u8c03\u7528 deleteOne");
        this.announcementService.deleteAnnouncement(one);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/announcementController/addOne.do"})
    public void addOne(AnnouncementEntity one, HttpServletResponse response) {
        this.LOGGER.info("\u8c03\u7528 addOne");
        MyAssert.hasText(one.getTitle(), "title \u4e0d\u80fd\u4e3a\u7a7a");
        MyAssert.notNull(one.getPublishTime(), "publishTime \u4e0d\u80fd\u4e3a\u7a7a");
        MyAssert.hasText(one.getDepartment(), "department \u4e0d\u80fd\u4e3a\u7a7a");
        MyAssert.hasText(one.getContent(), "content \u4e0d\u80fd\u4e3a\u7a7a");
        MyAssert.isTrue(one.getContent().length() < 10000, "content \u5185\u5bb9\u8fc7\u957f");
        if (!CollectionUtils.isEmpty(one.getAttachmentList())) {
            ArrayList uploadFileList = Lists.newArrayList();
            for (MultipartFile f : one.getAttachmentList()) {
                if (f.isEmpty()) continue;
                FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(f, f.getOriginalFilename());
                uploadFileList.add(fastFileInfo);
            }
            one.setFastFileList(uploadFileList);
        }
        one.setId(null);
        String announcementId = this.announcementService.publishAnnouncement(one);
        ObjectNode rst = QuickJson.newObjectNode().put("announcementId", announcementId);
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }
}

