/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.xatl.bims.bean.PersonBean;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.ruyihu.bean.BusinessTripDetailBean;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.service.CalendarService;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.MyAssert;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
@Scope(value="session")
public class BusinessTripController
extends BaseControler {
    private static final Logger logger = LoggerFactory.getLogger(BusinessTripController.class);
    @Resource
    private IBusinessTripService businessTripService;
    @Resource
    private UserManageServiceForXatl userManageService;
    @Resource
    private CalendarService calendarService;

    @RequestMapping(value={"/ruyihu/leaveController/businessTrip/listPage.do"})
    public String listPage() {
        return "ruyihu/businesstrip/default/list";
    }

    @RequestMapping(value={"/ruyihu/leaveController/businessTrip/detailPage.do"})
    public String detailPage() {
        return "ruyihu/businesstrip/default/detailPage";
    }

    @RequestMapping(value={"ruyihu/leaveController/businessTrip/delete.do"})
    public void delete(String applyId, HttpServletResponse response) {
        this.businessTripService.delete(applyId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/ruyihu/leaveController/businessTrip/list.do"})
    public void list(@RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, @RequestParam(required=false) String personNameLike, @RequestParam(required=false) Integer approvalStatus, @RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, HttpServletResponse response) throws Exception {
        Page pageParam = new Page(page, rows);
        Date begin = null;
        Date end = null;
        if (StringUtils.isNotEmpty((CharSequence)beginDate)) {
            begin = Util.parseDate((String)beginDate, (String)"yyyy-MM-dd");
        }
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            end = Util.parseDate((String)endDate, (String)"yyyy-MM-dd");
        }
        List<BusinessTripEntity> list = this.businessTripService.businessTripList(personNameLike, approvalStatus, begin, end, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(list)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (BusinessTripEntity businessTrip : list) {
                PersonBean personBean = this.userManageService.getPersonById(businessTrip.getTripUserId());
                ObjectNode node = QuickJson.newObjectNode();
                node.put("applyId", businessTrip.getApplyId());
                node.put("personId", businessTrip.getTripUserId());
                node.put("personName", personBean.getNAME());
                node.put("depId", personBean.getDEPID());
                node.put("depName", personBean.getDEPNAME());
                node.put("approvalStatus", businessTrip.getStatus());
                node.put("days", this.calendarService.getIntervalDays(businessTrip.getStartDate(), businessTrip.getEndDate()) + 1);
                node.put("startDate", Util.getDate((String)"yyyy-MM-dd", (Date)businessTrip.getStartDate()));
                node.put("endDate", Util.getDate((String)"yyyy-MM-dd", (Date)businessTrip.getEndDate()));
                rowsNode.add((JsonNode)node);
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        logger.info("\u8c03\u7528list\u7ed3\u679c\uff1a" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/ruyihu/leaveController/businessTrip/detail.do"})
    public void detail(String applyId, HttpServletResponse response) {
        BusinessTripDetailBean businessTripDetail = this.businessTripService.businessTripDetail(null, applyId);
        Util.writeUtf8Text((HttpServletResponse)response, (String)QuickJson.toJsonStr(businessTripDetail));
    }

    @RequestMapping(value={"ruyihu/leaveController/businessTrip/pdf.do"})
    public void pdf(String applyId, HttpServletResponse response) throws Exception {
        MyAssert.hasText(applyId, "applyId \u4e0d\u80fd\u4e3a\u7a7a");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        byte[] bytes = this.businessTripService.reportToPDF(applyId);
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", "attachment;fileName=businessTrip" + DateFormatUtils.format((Date)LakeMobUtils.now(), (String)"yyyyMMddHHmmss") + ".pdf");
        response.setContentLength(bytes.length);
        servletOutputStream.write(bytes, 0, bytes.length);
        servletOutputStream.flush();
        servletOutputStream.close();
    }
}

